# sigye (시계)

[![Crates.io](https://img.shields.io/crates/v/sigye)](https://crates.io/crates/sigye)
[![License](https://img.shields.io/crates/l/sigye)](https://github.com/am2rican5/sigye/blob/main/LICENSE)
[![Built With Ratatui](https://img.shields.io/badge/Built_With_Ratatui-000?logo=ratatui&logoColor=fff)](https://ratatui.rs/)

A beautiful terminal clock with ASCII art fonts. The name "sigye" (시계) means "clock" in Korean.

![sigye demo](assets/demo.gif)

## Features

- **40 bundled FIGlet fonts** - From classic Standard to stylish Star Wars
- **17 color themes** - Including rainbow, gradient, and winter effects
- **14 background styles** - Starfield, weather, twilight, and system-reactive visuals
- **Animated themes** - Shifting, pulsing, wave, and reactive effects
- **Blinking colon** - Optional colon separator animation
- **12/24 hour format** - Toggle with a single keypress
- **Live settings preview** - See changes before saving
- **Persistent configuration** - Settings saved automatically
- **Custom font support** - Add your own FIGlet fonts

## Installation

### From crates.io

```bash
cargo install sigye
```

### From source

```bash
git clone https://github.com/am2rican5/sigye
cd sigye
cargo install --path crates/sigye
```

## Usage

```bash
sigye
```

## Keybindings

| Key | Action |
|-----|--------|
| `q` / `Esc` | Quit |
| `t` | Toggle 12/24 hour format |
| `c` | Cycle color theme |
| `a` | Cycle animation style |
| `b` | Cycle background style |
| `s` | Open settings dialog |

### Settings Dialog

| Key | Action |
|-----|--------|
| `↑` / `k` | Previous field |
| `↓` / `j` | Next field |
| `←` / `h` | Previous value |
| `→` / `l` | Next value |
| `Enter` | Save settings |
| `Esc` | Cancel |

## Configuration

Configuration is stored at `~/.config/sigye/config.toml`:

```toml
font_name = "Standard"
color_theme = "Cyan"
time_format = "TwentyFourHour"
animation_style = "None"
animation_speed = "Medium"
colon_blink = false
background_style = "None"
weather_location = ""  # Empty for auto-detect, or set city name (e.g., "Seoul")
```

### Custom Fonts

Place FIGlet font files (`.flf`) in `~/.config/sigye/fonts/` and they will appear in the settings dialog.

## Color Themes

### Static Colors
Cyan, Green, White, Magenta, Yellow, Red, Blue

### Dynamic Gradients
- **Rainbow** - Horizontal rainbow spectrum
- **Rainbow V** - Vertical rainbow
- **Warm** - Red to Orange to Yellow
- **Cool** - Blue to Cyan to Green
- **Ocean** - Dark blue to Cyan to Teal
- **Neon** - Magenta to Cyan (synthwave)
- **Fire** - Red to Orange to Yellow
- **Frost** - White to Ice Blue to Steel Blue
- **Aurora** - Green to Cyan to Blue to Purple
- **Winter** - Deep Blue to Royal Blue to Ice Blue

## Animations

### Animation Styles
- **None** - Static display (default)
- **Shifting** - Color hue shifts over time
- **Pulsing** - Brightness pulses rhythmically
- **Wave** - Color wave moves across the display
- **Reactive** - Responds to time changes

### Animation Speeds
Slow, Medium (default), Fast

## Background Styles

### Classic
- **None** - No background (default)
- **Starfield** - Twinkling stars with varying brightness
- **Matrix** - Falling green Matrix-style characters
- **Gradient** - Flowing diagonal color wave

### Atmospheric
Weather, seasonal, and time-of-day effects:
- **Weather** - Auto-selects based on real-time conditions via wttr.in
- **Sunny** - Radiant sun with animated rays
- **Cloudy** - Layered drifting clouds
- **Foggy** - Ground-hugging mist effect
- **Rainy** - Falling rain droplets
- **Stormy** - Rain with lightning flashes
- **Windy** - Horizontal wind streaks
- **Snowfall** - Drifting snowflakes in shades of blue
- **Frost** - Ice crystals growing from screen edges
- **Aurora** - Northern lights in green, cyan, blue, and purple
- **Dawn** - Sunrise gradient with fading stars
- **Dusk** - Sunset gradient with emerging stars

### System-Reactive
Visualizations driven by real-time system metrics:
- **Sys Pulse** - CPU usage drives pulsing rings from center
- **Resource** - Memory usage controls wave amplitude
- **Data Flow** - Network I/O drives particle density
- **Heat Map** - Combined metrics as color intensity

## Bundled Fonts

3D-ASCII, Acrobatic, Alligator, Alphabet, ANSI Regular, ANSI Shadow, Avatar, Banner, Bell, Big, Big Money-ne, Block, BlurVision ASCII, Chunky, Colossal, Doh, Doom, Electronic, Epic, Graffiti, Ivrit, Larry 3D, Lean, Mini, Mono 9, Mono 12, Ogre, Poison, Puffy, Rebel, Rectangles, Script, Shadow, Slant, Small, Speed, Standard, Star Wars, Terrace, Tmplr

## License

Copyright (c) am2rican5

This project is licensed under the MIT license ([LICENSE](./LICENSE) or <http://opensource.org/licenses/MIT>)
