//===- MCDirectives.h - Enums for directives on various targets -*- C++ -*-===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//
//
// This file defines various enums that represent target-specific directives.
//
//===----------------------------------------------------------------------===//

#ifndef LLVM_MC_MCDIRECTIVES_H
#define LLVM_MC_MCDIRECTIVES_H

namespace llvm {

enum MCSymbolAttr {
  MCSA_Invalid = 0, ///< Not a valid directive.

  // Various directives in alphabetical order.
  MCSA_Cold,                    ///< .cold (MachO)
  MCSA_ELF_TypeFunction,        ///< .type _foo, STT_FUNC  # aka @function
  MCSA_ELF_TypeIndFunction,     ///< .type _foo, STT_GNU_IFUNC
  MCSA_ELF_TypeObject,          ///< .type _foo, STT_OBJECT  # aka @object
  MCSA_ELF_TypeTLS,             ///< .type _foo, STT_TLS     # aka @tls_object
  MCSA_ELF_TypeCommon,          ///< .type _foo, STT_COMMON  # aka @common
  MCSA_ELF_TypeNoType,          ///< .type _foo, STT_NOTYPE  # aka @notype
  MCSA_ELF_TypeGnuUniqueObject, /// .type _foo, @gnu_unique_object
  MCSA_Global,                  ///< .globl
  MCSA_LGlobal,                 ///< .lglobl (XCOFF)
  MCSA_Extern,                  ///< .extern (XCOFF)
  MCSA_Hidden,                  ///< .hidden (ELF)
  MCSA_Exported,                ///< .globl _foo, exported (XCOFF)
  MCSA_IndirectSymbol,          ///< .indirect_symbol (MachO)
  MCSA_Internal,                ///< .internal (ELF)
  MCSA_LazyReference,           ///< .lazy_reference (MachO)
  MCSA_Local,                   ///< .local (ELF)
  MCSA_NoDeadStrip,             ///< .no_dead_strip (MachO)
  MCSA_SymbolResolver,          ///< .symbol_resolver (MachO)
  MCSA_AltEntry,                ///< .alt_entry (MachO)
  MCSA_PrivateExtern,           ///< .private_extern (MachO)
  MCSA_Protected,               ///< .protected (ELF)
  MCSA_Reference,               ///< .reference (MachO)
  MCSA_Weak,                    ///< .weak
  MCSA_WeakDefinition,          ///< .weak_definition (MachO)
  MCSA_WeakReference,           ///< .weak_reference (MachO)
  MCSA_WeakDefAutoPrivate,      ///< .weak_def_can_be_hidden (MachO)
  MCSA_WeakAntiDep,             ///< .weak_anti_dep (COFF)
  MCSA_Memtag,                  ///< .memtag (ELF)
  MCSA_OSLinkage,               ///< symbol uses OS linkage (GOFF)
  MCSA_XPLinkage,               ///< symbol uses XP linkage (GOFF)
};

enum MCDataRegionType {
  MCDR_DataRegion,            ///< .data_region
  MCDR_DataRegionJT8,         ///< .data_region jt8
  MCDR_DataRegionJT16,        ///< .data_region jt16
  MCDR_DataRegionJT32,        ///< .data_region jt32
  MCDR_DataRegionEnd          ///< .end_data_region
};

enum MCVersionMinType {
  MCVM_IOSVersionMin,         ///< .ios_version_min
  MCVM_OSXVersionMin,         ///< .macosx_version_min
  MCVM_TvOSVersionMin,        ///< .tvos_version_min
  MCVM_WatchOSVersionMin,     ///< .watchos_version_min
};

} // end namespace llvm

#endif
