/***************************************************************************
  
  CKey.cpp
  
  (c) Benoît Minisini <benoit.minisini@gambas-basic.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
  MA 02110-1301, USA.
  
***************************************************************************/

#define __CKEY_CPP


#include "gambas.h"

#include "main.h"

#include <QKeyEvent>

#include "CWidget.h"
#include "CKey.h"

CKEY_INFO CKEY_info = { 0 };

void CKEY_clear(int valid)
{
  if (valid)
    CKEY_info.valid++;
  else
    CKEY_info.valid--;

  if (CKEY_info.valid == 0)
  {
    GB.FreeString(&CKEY_info.text);
    CKEY_info = { 0 };
  }
}

BEGIN_METHOD_VOID(CKEY_exit)

  GB.FreeString(&CKEY_info.text);

END_METHOD


BEGIN_METHOD(CKEY_get, GB_STRING key)

	GB.ReturnInteger(CKEY_get_keyval_from_name(GB.ToZeroString(ARG(key))));

END_METHOD

#define CHECK_VALID() \
  if (!CKEY_is_valid()) \
  { \
    GB.Error("No keyboard event data"); \
    return; \
  }

BEGIN_PROPERTY(Key_Text)

  CHECK_VALID();
  GB.ReturnString(CKEY_info.text);

END_PROPERTY

BEGIN_PROPERTY(Key_Code)

  CHECK_VALID();
	
	/*switch(CKEY_info.code)
	{
		case Qt::Key_Shift:
		case Qt::Key_Control:
		case Qt::Key_Alt:
		case Qt::Key_Meta:
			GB.ReturnInteger(0);
			break;
		
		default:*/
			GB.ReturnInteger(CKEY_info.code);
	//}

END_PROPERTY

BEGIN_PROPERTY(Key_State)

  CHECK_VALID();
  GB.ReturnInteger(CKEY_info.state);

END_PROPERTY

BEGIN_PROPERTY(Key_Shift)

  CHECK_VALID();
  GB.ReturnBoolean(CKEY_info.state & Qt::ShiftModifier); // || (CKEY_info.code == Qt::Key_Shift));

END_PROPERTY

BEGIN_PROPERTY(Key_Control)

  CHECK_VALID();
  GB.ReturnBoolean(CKEY_info.state & Qt::ControlModifier); // || (CKEY_info.code == Qt::Key_Control));

END_PROPERTY

BEGIN_PROPERTY(Key_Alt)

  CHECK_VALID();
  GB.ReturnBoolean(CKEY_info.state & Qt::AltModifier); // || (CKEY_info.code == Qt::Key_Alt));

END_PROPERTY

BEGIN_PROPERTY(Key_Meta)

  CHECK_VALID();
  GB.ReturnBoolean(CKEY_info.state & Qt::MetaModifier); // || (CKEY_info.code == Qt::Key_Meta));

END_PROPERTY

BEGIN_PROPERTY(Key_Normal)

  CHECK_VALID();
  GB.ReturnBoolean((CKEY_info.state & (Qt::ShiftModifier | Qt::ControlModifier | Qt::AltModifier | Qt::MetaModifier)) == 0);

END_PROPERTY

BEGIN_PROPERTY(Key_Shortcut)

	static GB_FUNCTION func;
	static bool init = FALSE;
	
	if (!init)
	{
		init = TRUE;
		GB.GetFunction(&func, (void *)GB.FindClass("Shortcut"), "FromKey", NULL, "s");
	}
	
	if (GB_FUNCTION_IS_VALID(&func))
		GB.Call(&func, 0, FALSE);
	else
		GB.ReturnNull();

END_PROPERTY

BEGIN_METHOD(Key_Send, GB_STRING text)

	QKeyEvent *event;
	int state = Qt::NoModifier;
	int code;
	QWidget *widget;
	char *text = GB.ToZeroString(ARG(text));
	QString str;
	
	if (CKEY_is_valid())
	{
		GB.Error("Ongoing keyboard event");
		return;
	}
	
	if (!CWIDGET_active_control)
	{
		GB.Error("No active control");
		return;
	}
	
	while (*text)
	{
		if (GB.StrNCaseCmp(text, "SHIFT+", 6) == 0) { state |= Qt::ShiftModifier; text += 6; }
		else if (GB.StrNCaseCmp(text, "CTRL+", 5) == 0) { state |= Qt::ControlModifier; text += 5; }
		else if (GB.StrNCaseCmp(text, "CONTROL+", 8) == 0) { state |= Qt::ControlModifier; text += 8; }
		else if (GB.StrNCaseCmp(text, "ALT+", 4) == 0) { state |= Qt::AltModifier; text += 4; }
		else if (GB.StrNCaseCmp(text, "META+", 5) == 0) { state |= Qt::MetaModifier; text += 5; }
		else break;
	}
	
	if (!*text)
		return;
	
	code = CKEY_get_keyval_from_name(text);
	if (!code)
		return;
	
	/*if (VARGOPT(shift, FALSE)) state |= Qt::ShiftModifier;
	if (VARGOPT(ctrl, FALSE)) state |= Qt::ControlModifier;
	if (VARGOPT(alt, FALSE)) state |= Qt::AltModifier;
	if (VARGOPT(meta, FALSE)) state |= Qt::MetaModifier;*/
	
	widget = QWIDGET(CWIDGET_active_control);
	
	str = TO_QSTRING(text);
	if (str.length() > 1) str = QString();
	
	event = new QKeyEvent(QEvent::KeyPress, code, (Qt::KeyboardModifier)state, str);
	qApp->sendEvent(widget, event);
	delete event;
	
	event = new QKeyEvent(QEvent::KeyRelease, code, (Qt::KeyboardModifier)state);
	qApp->sendEvent(widget, event);
	delete event;

END_METHOD

//-------------------------------------------------------------------------

GB_DESC CKeyDesc[] =
{
  GB_DECLARE("Key", 0), GB_VIRTUAL_CLASS(),

  GB_STATIC_METHOD("_get", "i", CKEY_get, "(Key)s"),
  GB_STATIC_METHOD("_exit", NULL, CKEY_exit, NULL),

  GB_CONSTANT("Esc", "i", Qt::Key_Escape),
  GB_CONSTANT("Escape", "i", Qt::Key_Escape),
  GB_CONSTANT("Tab", "i", Qt::Key_Tab),
  GB_CONSTANT("BackTab", "i", Qt::Key_Backtab),
  GB_CONSTANT("Backspace", "i", Qt::Key_Backspace),
  GB_CONSTANT("Return", "i", Qt::Key_Return),
  GB_CONSTANT("Enter", "i", Qt::Key_Enter),
  GB_CONSTANT("Ins", "i", Qt::Key_Insert),
  GB_CONSTANT("Del", "i", Qt::Key_Delete),
  GB_CONSTANT("Insert", "i", Qt::Key_Insert),
  GB_CONSTANT("Delete", "i", Qt::Key_Delete),
  GB_CONSTANT("Pause", "i", Qt::Key_Pause),
  GB_CONSTANT("Print", "i", Qt::Key_Print),
  GB_CONSTANT("SysReq", "i", Qt::Key_SysReq),
  GB_CONSTANT("Home", "i", Qt::Key_Home),
  GB_CONSTANT("End", "i", Qt::Key_End),
  GB_CONSTANT("Left", "i", Qt::Key_Left),
  GB_CONSTANT("Up", "i", Qt::Key_Up),
  GB_CONSTANT("Right", "i", Qt::Key_Right),
  GB_CONSTANT("Down", "i", Qt::Key_Down),
  GB_CONSTANT("PgUp", "i", Qt::Key_PageUp),
  GB_CONSTANT("PgDown", "i", Qt::Key_PageDown),
  GB_CONSTANT("PageUp", "i", Qt::Key_PageUp),
  GB_CONSTANT("PageDown", "i", Qt::Key_PageDown),
  GB_CONSTANT("ShiftKey", "i", Qt::Key_Shift),
  GB_CONSTANT("ControlKey", "i", Qt::Key_Control),
  GB_CONSTANT("MetaKey", "i", Qt::Key_Meta),
  GB_CONSTANT("AltKey", "i", Qt::Key_Alt),
  GB_CONSTANT("AltGrKey", "i", Qt::Key_AltGr),
  GB_CONSTANT("CapsLock", "i", Qt::Key_CapsLock),
  GB_CONSTANT("NumLock", "i", Qt::Key_NumLock),
  GB_CONSTANT("ScrollLock", "i", Qt::Key_ScrollLock),
  GB_CONSTANT("Clear", "i", Qt::Key_Clear),
  GB_CONSTANT("F1", "i", Qt::Key_F1),
  GB_CONSTANT("F2", "i", Qt::Key_F2),
  GB_CONSTANT("F3", "i", Qt::Key_F3),
  GB_CONSTANT("F4", "i", Qt::Key_F4),
  GB_CONSTANT("F5", "i", Qt::Key_F5),
  GB_CONSTANT("F6", "i", Qt::Key_F6),
  GB_CONSTANT("F7", "i", Qt::Key_F7),
  GB_CONSTANT("F8", "i", Qt::Key_F8),
  GB_CONSTANT("F9", "i", Qt::Key_F9),
  GB_CONSTANT("F10", "i", Qt::Key_F10),
  GB_CONSTANT("F11", "i", Qt::Key_F11),
  GB_CONSTANT("F12", "i", Qt::Key_F12),
  GB_CONSTANT("F13", "i", Qt::Key_F13),
  GB_CONSTANT("F14", "i", Qt::Key_F14),
  GB_CONSTANT("F15", "i", Qt::Key_F15),
  GB_CONSTANT("F16", "i", Qt::Key_F16),
  GB_CONSTANT("F17", "i", Qt::Key_F17),
  GB_CONSTANT("F18", "i", Qt::Key_F18),
  GB_CONSTANT("F19", "i", Qt::Key_F19),
  GB_CONSTANT("F20", "i", Qt::Key_F20),
  GB_CONSTANT("F21", "i", Qt::Key_F21),
  GB_CONSTANT("F22", "i", Qt::Key_F22),
  GB_CONSTANT("F23", "i", Qt::Key_F23),
  GB_CONSTANT("F24", "i", Qt::Key_F24),
  GB_CONSTANT("Menu", "i", Qt::Key_Menu),
  GB_CONSTANT("Help", "i", Qt::Key_Help),
  GB_CONSTANT("Space", "i", Qt::Key_Space),

  GB_STATIC_PROPERTY_READ("Text", "s", Key_Text),
  GB_STATIC_PROPERTY_READ("Code", "i{Key}", Key_Code),
  GB_STATIC_PROPERTY_READ("State", "i", Key_State),
  GB_STATIC_PROPERTY_READ("Shift", "b", Key_Shift),
  GB_STATIC_PROPERTY_READ("Control", "b", Key_Control),
  GB_STATIC_PROPERTY_READ("Alt", "b", Key_Alt),
  GB_STATIC_PROPERTY_READ("Meta", "b", Key_Meta),
  GB_STATIC_PROPERTY_READ("Normal", "b", Key_Normal),
  
  GB_STATIC_PROPERTY_READ("Shortcut", "s", Key_Shortcut),
  
  GB_STATIC_METHOD("Send", NULL, Key_Send, "(Shortcut)s"),
  
  GB_END_DECLARE
};

//-------------------------------------------------------------------------

int CKEY_get_keyval_from_name(const char *name)
{
	const GB_DESC *p;
	const char *pname;

	if (!name || !*name)
		return 0;
	
	if (!name[1] && name[0] >= 32 && name[0] < 128)
		return name[0];
	
	for(p = &CKeyDesc[3]; (pname = p->name); p++)
	{
		if (*pname != GB_CONSTANT_ID)
			continue;
		if (strcasecmp(name, &pname[1]) == 0)
			return (int)p->val2;
	}
	
  QKeySequence ks(name);

#if QT6
  return ks[0].key();
#else
  return ks[0] & ~Qt::UNICODE_ACCEL;
#endif
}
