
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was TNLConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

# Use original install prefix when loaded through a "/usr move"
# cross-prefix symbolic link such as /lib -> /usr/lib.
get_filename_component(_realCurr "${CMAKE_CURRENT_LIST_DIR}" REALPATH)
get_filename_component(_realOrig "/usr/lib/cmake/TNL" REALPATH)
if(_realCurr STREQUAL _realOrig)
  set(PACKAGE_PREFIX_DIR "/usr")
endif()
unset(_realOrig)
unset(_realCurr)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set(TNL_PROJECT_NAME "TNL")
set(TNL_PROJECT_VERSION 0.1)

# CMake build configuration
set(TNL_BUILD_TYPE "Release")
set(TNL_EXECUTABLE_SUFFIX "")

# Compiler configuration
set(TNL_C_COMPILER "/usr/bin/cc")
set(TNL_C_COMPILER_VERSION 15.2.1)
set(TNL_CXX_COMPILER "/usr/bin/c++")
set(TNL_CXX_COMPILER_VERSION 15.2.1)
set(TNL_CUDA_COMPILER "/opt/cuda/bin/nvcc")
set(TNL_CUDA_COMPILER_VERSION 13.0.88)
set(TNL_CUDA_ARCHITECTURES 75;80;86;87;88;89;90;100;103;110;120;121;121-virtual)
set(TNL_CUDA_HOST_COMPILER "")

set(TNL_C_FLAGS "-march=x86-64 -mtune=generic -O2 -pipe -fno-plt -fexceptions         -Wp,-D_FORTIFY_SOURCE=3 -Wformat -Werror=format-security         -fstack-clash-protection -fcf-protection         -fno-omit-frame-pointer -mno-omit-leaf-frame-pointer -g -ffile-prefix-map=/build/tnl-git/src=/usr/src/debug/tnl-git")
set(TNL_C_FLAGS_DEBUG "-g")
set(TNL_C_FLAGS_RELEASE "-O3 -DNDEBUG")
set(TNL_C_FLAGS_RELWITHDEBINFO "-O2 -g -DNDEBUG")
set(TNL_CXX_FLAGS "-march=x86-64 -mtune=generic -O2 -pipe -fno-plt -fexceptions         -Wp,-D_FORTIFY_SOURCE=3 -Wformat -Werror=format-security         -fstack-clash-protection -fcf-protection         -fno-omit-frame-pointer -mno-omit-leaf-frame-pointer -Wp,-D_GLIBCXX_ASSERTIONS -g -ffile-prefix-map=/build/tnl-git/src=/usr/src/debug/tnl-git -Wall -Werror=vla -Wextra-semi -Wno-maybe-uninitialized -DHAVE_DCMTK_H -DHAVE_PNG_H -DHAVE_JPEG_H")
set(TNL_CXX_FLAGS_DEBUG "-g")
set(TNL_CXX_FLAGS_RELEASE "-O3 -DNDEBUG")
set(TNL_CXX_FLAGS_RELWITHDEBINFO "-O3 -DNDEBUG -g")
set(TNL_CUDA_FLAGS " -Wall")
set(TNL_CUDA_FLAGS_DEBUG "-g")
set(TNL_CUDA_FLAGS_RELEASE "-O3 -DNDEBUG")
set(TNL_CUDA_FLAGS_RELWITHDEBINFO "-O3 -DNDEBUG -g --generate-line-info")

set(TNL_SHARED_LIBRARY_LINK_C_FLAGS "-rdynamic")
set(TNL_SHARED_LIBRARY_LINK_C_FLAGS_DEBUG "")
set(TNL_SHARED_LIBRARY_LINK_C_FLAGS_RELEASE "")
set(TNL_EXE_LINKER_FLAGS "-Wl,-O1 -Wl,--sort-common -Wl,--as-needed -Wl,-z,relro -Wl,-z,now          -Wl,-z,pack-relative-relocs")
set(TNL_EXE_LINKER_FLAGS_DEBUG "")
set(TNL_EXE_LINKER_FLAGS_RELEASE "")
set(TNL_SHARED_LINKER_FLAGS "-Wl,-O1 -Wl,--sort-common -Wl,--as-needed -Wl,-z,relro -Wl,-z,now          -Wl,-z,pack-relative-relocs")
set(TNL_SHARED_LINKER_FLAGS_DEBUG "")
set(TNL_SHARED_LINKER_FLAGS_RELEASE "")

# TNL configuration
set(TNL_INSTALL_HEADERS )
set(TNL_BUILD_OPENMP TRUE)
set(TNL_BUILD_CUDA TRUE)
set(TNL_BUILD_MPI TRUE)

set(TNL_BUILD_COVERAGE OFF)
set(TNL_OFFLINE_BUILD OFF)
set(TNL_USE_CI_FLAGS OFF)

# set cmake's include path so that we can include custom modules from
# the TNL installation path
list(APPEND CMAKE_MODULE_PATH "${CMAKE_CURRENT_LIST_DIR}/Modules")

# find the std::filesystem library
find_package(Filesystem REQUIRED COMPONENTS Final)

# find the thread library
set(CMAKE_THREAD_PREFER_PTHREAD TRUE)
set(THREADS_PREFER_PTHREAD_FLAG TRUE)
find_package(Threads REQUIRED)

# Check for OpenMP if it is enabled
if(TNL_BUILD_OPENMP)
    find_package(OpenMP COMPONENTS CXX)
endif()

# Check for MPI if it is enabled
if(TNL_BUILD_MPI)
    find_package(MPI COMPONENTS CXX)
endif()

include(${CMAKE_CURRENT_LIST_DIR}/TNLTargets.cmake)
