
# Autogenerated by mlir-tblgen; don't manually edit.

from ._ods_common import _cext as _ods_cext
from ._ods_common import (
    equally_sized_accessor as _ods_equally_sized_accessor,
    get_default_loc_context as _ods_get_default_loc_context,
    get_op_results_or_values as _get_op_results_or_values,
    segmented_accessor as _ods_segmented_accessor,
)
_ods_ir = _ods_cext.ir
_ods_cext.globals.register_traceback_file_exclusion(__file__)

import builtins
from typing import Sequence as _Sequence, Union as _Union, Optional as _Optional


@_ods_cext.register_dialect
class _Dialect(_ods_ir.Dialect):
  DIALECT_NAMESPACE = "math"

@_ods_cext.register_operation(_Dialect)
class AbsFOp(_ods_ir.OpView):
  r"""
  The `absf` operation computes the absolute value. It takes one operand of
  floating point type (i.e., scalar, tensor or vector) and returns one result
  of the same type.
  
  Example:
  
  ```mlir
  // Scalar absolute value.
  %a = math.absf %b : f64
  ```
  """

  OPERATION_NAME = "math.absf"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def absf(operand, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return AbsFOp(operand=operand, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class AbsIOp(_ods_ir.OpView):
  r"""
  The `absi` operation computes the absolute value. It takes one operand of
  integer type (i.e., scalar, tensor or vector) and returns one result of the
  same type.
  
  Example:
  
  ```mlir
  // Scalar absolute value.
  %a = math.absi %b : i64
  ```
  """

  OPERATION_NAME = "math.absi"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def absi(operand, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return AbsIOp(operand=operand, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class AcosOp(_ods_ir.OpView):
  r"""
  The `acos` operation computes the arcus cosine of a given value. It takes one
  operand of floating point type (i.e., scalar, tensor or vector) and returns one
  result of the same type.  It has no standard attributes.
  
  Example:
  
  ```mlir
  // Scalar arcus cosine value.
  %a = math.acos %b : f64
  ```
  """

  OPERATION_NAME = "math.acos"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def acos(operand, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return AcosOp(operand=operand, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class AcoshOp(_ods_ir.OpView):
  r"""
  Syntax:
  
  ```
  operation ::= ssa-id `=` `math.acosh` ssa-use `:` type
  ```
  
  The `acosh` operation computes the arcus cosine of a given value.  It takes
  one operand of floating point type (i.e., scalar, tensor or vector) and returns
  one result of the same type. It has no standard attributes.
  
  Example:
  
  ```mlir
  // Hyperbolic arcus cosine of scalar value.
  %a = math.acosh %b : f64
  ```
  """

  OPERATION_NAME = "math.acosh"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def acosh(operand, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return AcoshOp(operand=operand, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class AsinOp(_ods_ir.OpView):
  r"""
  Syntax:
  
  ```
  operation ::= ssa-id `=` `math.asin` ssa-use `:` type
  ```
  
  The `asin` operation computes the arcus sine of a given value.  It takes
  one operand of floating point type (i.e., scalar, tensor or vector) and returns
  one result of the same type. It has no standard attributes.
  
  Example:
  
  ```mlir
  // Arcus sine of scalar value.
  %a = math.asin %b : f64
  ```
  """

  OPERATION_NAME = "math.asin"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def asin(operand, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return AsinOp(operand=operand, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class AsinhOp(_ods_ir.OpView):
  r"""
  Syntax:
  
  ```
  operation ::= ssa-id `=` `math.asinh` ssa-use `:` type
  ```
  
  The `asinh` operation computes the hyperbolic arcus sine of a given value.  It takes
  one operand of floating point type (i.e., scalar, tensor or vector) and returns
  one result of the same type. It has no standard attributes.
  
  Example:
  
  ```mlir
  // Hyperbolic arcus sine of scalar value.
  %a = math.asinh %b : f64
  ```
  """

  OPERATION_NAME = "math.asinh"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def asinh(operand, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return AsinhOp(operand=operand, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class Atan2Op(_ods_ir.OpView):
  r"""
  The `atan2` operation takes two operands and returns one result, all of
  which must be of the same type.  The operands must be of floating point type
  (i.e., scalar, tensor or vector).
  
  The 2-argument arcus tangent `atan2(y, x)` returns the angle in the
  Euclidian plane between the positive x-axis and the ray through the point
  (x, y).  It is a generalization of the 1-argument arcus tangent which
  returns the angle on the basis of the ratio y/x.
  
  See also https://en.wikipedia.org/wiki/Atan2
  
  Example:
  
  ```mlir
  // Scalar variant.
  %a = math.atan2 %b, %c : f32
  ```
  """

  OPERATION_NAME = "math.atan2"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def atan2(lhs, rhs, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return Atan2Op(lhs=lhs, rhs=rhs, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class AtanOp(_ods_ir.OpView):
  r"""
  The `atan` operation computes the arcus tangent of a given value.  It takes
  one operand of floating point type (i.e., scalar, tensor or vector) and returns
  one result of the same type. It has no standard attributes.
  
  Example:
  
  ```mlir
  // Arcus tangent of scalar value.
  %a = math.atan %b : f64
  ```
  """

  OPERATION_NAME = "math.atan"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def atan(operand, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return AtanOp(operand=operand, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class AtanhOp(_ods_ir.OpView):
  r"""
  Syntax:
  
  ```
  operation ::= ssa-id `=` `math.atanh` ssa-use `:` type
  ```
  
  The `atanh` operation computes the hyperbolic arcus tangent of a given value.  It takes
  one operand of floating point type (i.e., scalar, tensor or vector) and returns
  one result of the same type. It has no standard attributes.
  
  Example:
  
  ```mlir
  // Hyperbolic arcus tangent of scalar value.
  %a = math.atanh %b : f64
  ```
  """

  OPERATION_NAME = "math.atanh"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def atanh(operand, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return AtanhOp(operand=operand, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class CbrtOp(_ods_ir.OpView):
  r"""
  The `cbrt` operation computes the cube root. It takes one operand of
  floating point type (i.e., scalar, tensor or vector) and returns one result
  of the same type. It has no standard attributes.
  
  Example:
  
  ```mlir
  // Scalar cube root value.
  %a = math.cbrt %b : f64
  ```
  
  Note: This op is not equivalent to powf(..., 1/3.0).
  """

  OPERATION_NAME = "math.cbrt"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def cbrt(operand, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return CbrtOp(operand=operand, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class CeilOp(_ods_ir.OpView):
  r"""
  The `ceil` operation computes the ceiling of a given value. It takes one
  operand of floating point type (i.e., scalar, tensor or vector) and returns one
  result of the same type.  It has no standard attributes.
  
  Example:
  
  ```mlir
  // Scalar ceiling value.
  %a = math.ceil %b : f64
  ```
  """

  OPERATION_NAME = "math.ceil"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def ceil(operand, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return CeilOp(operand=operand, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ClampFOp(_ods_ir.OpView):
  r"""
  The `clampf` operation takes three operands and returns one result, each of
  these is required to be the same type. Operands must be of floating point type
  (i.e., scalar, tensor or vector).
  
  The semantics of the operation are described by:
  ```
    clampf(value, min, max) = maxf(minf(value, min), max)
  ```
  
  Example:
  
  ```mlir
  %d = math.clampf %value to [%min, %max] : f64
  ```
  """

  OPERATION_NAME = "math.clampf"

  _ODS_REGIONS = (0, True)

  def __init__(self, value, min, max, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(value)
    operands.append(min)
    operands.append(max)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def value(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def min(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def max(self) -> _ods_ir.Value:
    return self.operation.operands[2]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def clampf(value, min, max, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return ClampFOp(value=value, min=min, max=max, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class CopySignOp(_ods_ir.OpView):
  r"""
  The `copysign` returns a value with the magnitude of the first operand and
  the sign of the second operand. It takes two operands and returns one result of
  the same type. The operands must be of floating point type (i.e., scalar,
  tensor or vector). It has no standard attributes.
  
  Example:
  
  ```mlir
  // Scalar copysign value.
  %a = math.copysign %b, %c : f64
  ```
  """

  OPERATION_NAME = "math.copysign"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def copysign(lhs, rhs, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return CopySignOp(lhs=lhs, rhs=rhs, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class CosOp(_ods_ir.OpView):
  r"""
  The `cos` operation computes the cosine of a given value. It takes one
  operand of floating point type (i.e., scalar, tensor or vector) and returns one
  result of the same type.  It has no standard attributes.
  
  Example:
  
  ```mlir
  // Scalar cosine value.
  %a = math.cos %b : f64
  ```
  """

  OPERATION_NAME = "math.cos"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def cos(operand, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return CosOp(operand=operand, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class CoshOp(_ods_ir.OpView):
  r"""
  The `cosh` operation computes the hyperbolic cosine. It takes one operand
  of floating point type (i.e., scalar, tensor or vector) and returns one
  result of the same type. It has no standard attributes.
  
  Example:
  
  ```mlir
  // Scalar hyperbolic cosine value.
  %a = math.cosh %b : f64
  ```
  """

  OPERATION_NAME = "math.cosh"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def cosh(operand, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return CoshOp(operand=operand, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class CountLeadingZerosOp(_ods_ir.OpView):
  r"""
  The `ctlz` operation computes the number of leading zeros of an integer value.
  It operates on scalar, tensor or vector.
  
  Example:
  
  ```mlir
  // Scalar ctlz function value.
  %a = math.ctlz %b : i32
  ```
  """

  OPERATION_NAME = "math.ctlz"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def ctlz(operand, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return CountLeadingZerosOp(operand=operand, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class CountTrailingZerosOp(_ods_ir.OpView):
  r"""
  The `cttz` operation computes the number of trailing zeros of an integer value.
  It operates on scalar, tensor or vector.
  
  Example:
  
  ```mlir
  // Scalar cttz function value.
  %a = math.cttz %b : i32
  ```
  """

  OPERATION_NAME = "math.cttz"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def cttz(operand, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return CountTrailingZerosOp(operand=operand, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class CtPopOp(_ods_ir.OpView):
  r"""
  The `ctpop` operation computes the number of set bits of an integer value.
  It operates on scalar, tensor or vector.
  
  Example:
  
  ```mlir
  // Scalar ctpop function value.
  %a = math.ctpop %b : i32
  ```
  """

  OPERATION_NAME = "math.ctpop"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def ctpop(operand, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return CtPopOp(operand=operand, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ErfOp(_ods_ir.OpView):
  r"""
  The `erf` operation computes the error function. It takes one operand of
  floating point type (i.e., scalar, tensor or vector) and returns one result of
  the same type. It has no standard attributes.
  
  Example:
  
  ```mlir
  // Scalar error function value.
  %a = math.erf %b : f64
  ```
  """

  OPERATION_NAME = "math.erf"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def erf(operand, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return ErfOp(operand=operand, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ErfcOp(_ods_ir.OpView):
  r"""
  The `erfc` operation computes the complementary error function, defined as
  1-erf(x). This function is part of libm and is needed for accuracy, since
  simply calculating 1-erf(x) when x is close to 1 will give inaccurate results.
  It takes one operand of floating point type (i.e., scalar,
  tensor or vector) and returns one result of the same type. It has no
  standard attributes.
  
  Example:
  
  ```mlir
  // Scalar error function value.
  %a = math.erfc %b : f64
  ```
  """

  OPERATION_NAME = "math.erfc"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def erfc(operand, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return ErfcOp(operand=operand, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class Exp2Op(_ods_ir.OpView):
  r"""
  The `exp` operation takes one operand of floating point type (i.e., scalar,
  tensor or vector) and returns one result of the same type. It has no standard
  attributes.
  
  Example:
  
  ```mlir
  // Scalar natural exponential.
  %a = math.exp2 %b : f64
  ```
  """

  OPERATION_NAME = "math.exp2"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def exp2(operand, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return Exp2Op(operand=operand, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ExpM1Op(_ods_ir.OpView):
  r"""
  expm1(x) := exp(x) - 1
  
  The `expm1` operation takes one operand of floating point type (i.e.,
  scalar, tensor or vector) and returns one result of the same type. It has no
  standard attributes.
  
  Example:
  
  ```mlir
  // Scalar natural exponential minus 1.
  %a = math.expm1 %b : f64
  ```
  """

  OPERATION_NAME = "math.expm1"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def expm1(operand, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return ExpM1Op(operand=operand, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ExpOp(_ods_ir.OpView):
  r"""
  The `exp` operation takes one operand of floating point type (i.e., scalar,
  tensor or vector) and returns one result of the same type. It has no standard
  attributes.
  
  Example:
  
  ```mlir
  // Scalar natural exponential.
  %a = math.exp %b : f64
  ```
  """

  OPERATION_NAME = "math.exp"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def exp(operand, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return ExpOp(operand=operand, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class FPowIOp(_ods_ir.OpView):
  r"""
  The `fpowi` operation takes a `base` operand of floating point type
  (i.e. scalar, tensor or vector) and a `power` operand of integer type
  (also scalar, tensor or vector) and returns one result of the same type
  as `base`. The result is `base` raised to the power of `power`.
  The operation is elementwise for non-scalars, e.g.:
  
  ```mlir
  %v = math.fpowi %base, %power : vector<2xf32>, vector<2xi32
  ```
  
  The result is a vector of:
  
  ```
  [<math.fpowi %base[0], %power[0]>, <math.fpowi %base[1], %power[1]>]
  ```
  
  Example:
  
  ```mlir
  // Scalar exponentiation.
  %a = math.fpowi %base, %power : f64, i32
  ```
  """

  OPERATION_NAME = "math.fpowi"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def fpowi(lhs, rhs, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return FPowIOp(lhs=lhs, rhs=rhs, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class FloorOp(_ods_ir.OpView):
  r"""
  The `floor` operation computes the floor of a given value. It takes one
  operand of floating point type (i.e., scalar, tensor or vector) and returns one
  result of the same type.  It has no standard attributes.
  
  Example:
  
  ```mlir
  // Scalar floor value.
  %a = math.floor %b : f64
  ```
  """

  OPERATION_NAME = "math.floor"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def floor(operand, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return FloorOp(operand=operand, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class FmaOp(_ods_ir.OpView):
  r"""
  The `fma` operation takes three operands and returns one result, each of
  these is required to be the same type. Operands must be of floating point type
  (i.e., scalar, tensor or vector).
  
  Example:
  
  ```mlir
  // Scalar fused multiply-add: d = a*b + c
  %d = math.fma %a, %b, %c : f64
  ```
  
  The semantics of the operation correspond to those of the `llvm.fma`
  [intrinsic](https://llvm.org/docs/LangRef.html#llvm-fma-intrinsic). In the
  particular case of lowering to LLVM, this is guaranteed to lower
  to the `llvm.fma.*` intrinsic.
  """

  OPERATION_NAME = "math.fma"

  _ODS_REGIONS = (0, True)

  def __init__(self, a, b, c, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(a)
    operands.append(b)
    operands.append(c)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def a(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def b(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def c(self) -> _ods_ir.Value:
    return self.operation.operands[2]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def fma(a, b, c, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return FmaOp(a=a, b=b, c=c, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class IPowIOp(_ods_ir.OpView):
  r"""
  The `ipowi` operation takes two operands of integer type (i.e., scalar,
  tensor or vector) and returns one result of the same type. Operands
  must have the same type.
  
  Example:
  
  ```mlir
  // Scalar signed integer exponentiation.
  %a = math.ipowi %b, %c : i32
  ```
  """

  OPERATION_NAME = "math.ipowi"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def ipowi(lhs, rhs, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return IPowIOp(lhs=lhs, rhs=rhs, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class IsFiniteOp(_ods_ir.OpView):
  r"""
  Determines if the given floating-point number has finite value i.e. it
  is normal, subnormal or zero, but not infinite or NaN.
  
  Example:
  
  ```mlir
  %f = math.isfinite %a : f32
  ```
  """

  OPERATION_NAME = "math.isfinite"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def isfinite(operand, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return IsFiniteOp(operand=operand, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class IsInfOp(_ods_ir.OpView):
  r"""
  Determines if the given floating-point number is positive or negative
  infinity.
  
  Example:
  
  ```mlir
  %f = math.isinf %a : f32
  ```
  """

  OPERATION_NAME = "math.isinf"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def isinf(operand, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return IsInfOp(operand=operand, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class IsNaNOp(_ods_ir.OpView):
  r"""
  Determines if the given floating-point number is a not-a-number (NaN)
  value.
  
  Example:
  
  ```mlir
  %f = math.isnan %a : f32
  ```
  """

  OPERATION_NAME = "math.isnan"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def isnan(operand, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return IsNaNOp(operand=operand, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class IsNormalOp(_ods_ir.OpView):
  r"""
  Determines if the given floating-point number is normal, i.e. is neither
  zero, subnormal, infinite, nor NaN.
  
  Example:
  
  ```mlir
  %f = math.isnormal %a : f32
  ```
  """

  OPERATION_NAME = "math.isnormal"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def isnormal(operand, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return IsNormalOp(operand=operand, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class Log1pOp(_ods_ir.OpView):
  r"""
  Computes the base-e logarithm of one plus the given value. It takes one
  operand of floating point type (i.e., scalar, tensor or vector) and returns one
  result of the same type.
  
  log1p(x) := log(1 + x)
  
  Example:
  
  ```mlir
  // Scalar log1p operation.
  %y = math.log1p %x : f64
  ```
  """

  OPERATION_NAME = "math.log1p"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def log1p(operand, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return Log1pOp(operand=operand, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class Log2Op(_ods_ir.OpView):
  r"""
  Computes the base-2 logarithm of the given value. It takes one operand of
  floating point type (i.e., scalar, tensor or vector) and returns one result of
  the same type.
  
  Example:
  
  ```mlir
  // Scalar log2 operation.
  %y = math.log2 %x : f64
  ```
  """

  OPERATION_NAME = "math.log2"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def log2(operand, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return Log2Op(operand=operand, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class Log10Op(_ods_ir.OpView):
  r"""
  Computes the base-10 logarithm of the given value. It takes one operand of
  floating point type (i.e., scalar, tensor or vector) and returns one result of
  the same type.
  
  Example:
  
  ```mlir
  // Scalar log10 operation.
  %y = math.log10 %x : f64
  ```
  """

  OPERATION_NAME = "math.log10"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def log10(operand, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return Log10Op(operand=operand, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class LogOp(_ods_ir.OpView):
  r"""
  Computes the base-e logarithm of the given value. It takes one operand of
  floating point type (i.e., scalar, tensor or vector) and returns one result of
  the same type.
  
  Example:
  
  ```mlir
  // Scalar log operation.
  %y = math.log %x : f64
  ```
  """

  OPERATION_NAME = "math.log"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def log(operand, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return LogOp(operand=operand, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class PowFOp(_ods_ir.OpView):
  r"""
  The `powf` operation takes two operands of floating point type (i.e.,
  scalar, tensor or vector) and returns one result of the same type. Operands
  must have the same type.
  
  Example:
  
  ```mlir
  // Scalar exponentiation.
  %a = math.powf %b, %c : f64
  ```
  """

  OPERATION_NAME = "math.powf"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def powf(lhs, rhs, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return PowFOp(lhs=lhs, rhs=rhs, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class RoundEvenOp(_ods_ir.OpView):
  r"""
  The `roundeven` operation returns the operand rounded to the nearest integer
  value in floating-point format. It takes one operand of floating point type
  (i.e., scalar, tensor or vector) and produces one result of the same type.  The
  operation rounds the argument to the nearest integer value in floating-point
  format, rounding halfway cases to even, regardless of the current
  rounding direction.
  
  Example:
  
  ```mlir
  // Scalar round operation.
  %a = math.roundeven %b : f64
  ```
  """

  OPERATION_NAME = "math.roundeven"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def roundeven(operand, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return RoundEvenOp(operand=operand, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class RoundOp(_ods_ir.OpView):
  r"""
  The `round` operation returns the operand rounded to the nearest integer
  value in floating-point format. It takes one operand of floating point type
  (i.e., scalar, tensor or vector) and produces one result of the same type.  The
  operation rounds the argument to the nearest integer value in floating-point
  format, rounding halfway cases away from zero, regardless of the current
  rounding direction.
  
  Example:
  
  ```mlir
  // Scalar round operation.
  %a = math.round %b : f64
  ```
  """

  OPERATION_NAME = "math.round"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def round(operand, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return RoundOp(operand=operand, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class RsqrtOp(_ods_ir.OpView):
  r"""
  The `rsqrt` operation computes the reciprocal of the square root. It takes
  one operand of floating point type (i.e., scalar, tensor or vector) and returns
  one result of the same type. It has no standard attributes.
  
  Example:
  
  ```mlir
  // Scalar reciprocal square root value.
  %a = math.rsqrt %b : f64
  ```
  """

  OPERATION_NAME = "math.rsqrt"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def rsqrt(operand, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return RsqrtOp(operand=operand, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class SinOp(_ods_ir.OpView):
  r"""
  The `sin` operation computes the sine of a given value. It takes one
  operand of floating point type (i.e., scalar, tensor or vector) and returns one
  result of the same type.  It has no standard attributes.
  
  Example:
  
  ```mlir
  // Scalar sine value.
  %a = math.sin %b : f64
  ```
  """

  OPERATION_NAME = "math.sin"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def sin(operand, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return SinOp(operand=operand, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class SincosOp(_ods_ir.OpView):
  r"""
  The `sincos` operation computes both the sine and cosine of a given value
  simultaneously. It takes one operand of floating point type (i.e., scalar,
  tensor or vector) and returns two results of the same type. This operation
  can be more efficient than computing sine and cosine separately when both
  values are needed.
  
  Example:
  
  ```mlir
  // Scalar sine and cosine values.
  %sin, %cos = math.sincos %input : f64
  ```
  """

  OPERATION_NAME = "math.sincos"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def sin(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

  @builtins.property
  def cos(self) -> _ods_ir.OpResult:
    return self.operation.results[1]

def sincos(operand, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResultList:
  return SincosOp(operand=operand, fastmath=fastmath, results=results, loc=loc, ip=ip).results

@_ods_cext.register_operation(_Dialect)
class SinhOp(_ods_ir.OpView):
  r"""
  The `sinh` operation computes the hyperbolic sine. It takes one operand
  of floating point type (i.e., scalar, tensor or vector) and returns one
  result of the same type. It has no standard attributes.
  
  Example:
  
  ```mlir
  // Scalar hyperbolic sine value.
  %a = math.sinh %b : f64
  ```
  """

  OPERATION_NAME = "math.sinh"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def sinh(operand, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return SinhOp(operand=operand, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class SqrtOp(_ods_ir.OpView):
  r"""
  The `sqrt` operation computes the square root. It takes one operand of
  floating point type (i.e., scalar, tensor or vector) and returns one result of
  the same type. It has no standard attributes.
  
  Example:
  
  ```mlir
  // Scalar square root value.
  %a = math.sqrt %b : f64
  ```
  """

  OPERATION_NAME = "math.sqrt"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def sqrt(operand, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return SqrtOp(operand=operand, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class TanOp(_ods_ir.OpView):
  r"""
  The `tan` operation computes the tangent. It takes one operand
  of floating point type (i.e., scalar, tensor or vector) and returns one
  result of the same type. It has no standard attributes.
  
  Example:
  
  ```mlir
  // Scalar tangent value.
  %a = math.tan %b : f64
  ```
  """

  OPERATION_NAME = "math.tan"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def tan(operand, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return TanOp(operand=operand, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class TanhOp(_ods_ir.OpView):
  r"""
  The `tanh` operation computes the hyperbolic tangent. It takes one operand
  of floating point type (i.e., scalar, tensor or vector) and returns one
  result of the same type. It has no standard attributes.
  
  Example:
  
  ```mlir
  // Scalar hyperbolic tangent value.
  %a = math.tanh %b : f64
  ```
  """

  OPERATION_NAME = "math.tanh"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def tanh(operand, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return TanhOp(operand=operand, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class TruncOp(_ods_ir.OpView):
  r"""
  The `trunc` operation returns the operand rounded to the nearest integer
  value in floating-point format. It takes one operand of floating point type
  (i.e., scalar, tensor or vector) and produces one result of the same type.
  The operation always rounds to the nearest integer not larger in magnitude
  than the operand, regardless of the current rounding direction.
  
  Example:
  
  ```mlir
  // Scalar trunc operation.
  %a = math.trunc %b : f64
  ```
  """

  OPERATION_NAME = "math.trunc"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def trunc(operand, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return TruncOp(operand=operand, fastmath=fastmath, results=results, loc=loc, ip=ip).result
