
# Autogenerated by mlir-tblgen; don't manually edit.

from enum import IntEnum, auto, IntFlag
from ._ods_common import _cext as _ods_cext
from ..ir import register_attribute_builder
_ods_ir = _ods_cext.ir

class AddressSpace(IntEnum):
    """GPU address space"""

    Global = 1
    Workgroup = 2
    Private = 3

    def __str__(self):
        if self is AddressSpace.Global:
            return "global"
        if self is AddressSpace.Workgroup:
            return "workgroup"
        if self is AddressSpace.Private:
            return "private"
        raise ValueError("Unknown AddressSpace enum entry.")



@register_attribute_builder("GPU_AddressSpaceEnum")
def _gpu_addressspaceenum(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class AllReduceOperation(IntEnum):
    """built-in reduction operations supported by gpu.allreduce."""

    ADD = 0
    MUL = 1
    MINUI = 2
    MINSI = 3
    MINNUMF = 4
    MAXUI = 5
    MAXSI = 6
    MAXNUMF = 7
    AND = 8
    OR = 9
    XOR = 10
    MINIMUMF = 11
    MAXIMUMF = 12

    def __str__(self):
        if self is AllReduceOperation.ADD:
            return "add"
        if self is AllReduceOperation.MUL:
            return "mul"
        if self is AllReduceOperation.MINUI:
            return "minui"
        if self is AllReduceOperation.MINSI:
            return "minsi"
        if self is AllReduceOperation.MINNUMF:
            return "minnumf"
        if self is AllReduceOperation.MAXUI:
            return "maxui"
        if self is AllReduceOperation.MAXSI:
            return "maxsi"
        if self is AllReduceOperation.MAXNUMF:
            return "maxnumf"
        if self is AllReduceOperation.AND:
            return "and"
        if self is AllReduceOperation.OR:
            return "or"
        if self is AllReduceOperation.XOR:
            return "xor"
        if self is AllReduceOperation.MINIMUMF:
            return "minimumf"
        if self is AllReduceOperation.MAXIMUMF:
            return "maximumf"
        raise ValueError("Unknown AllReduceOperation enum entry.")



@register_attribute_builder("GPU_AllReduceOperation")
def _gpu_allreduceoperation(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class BroadcastType(IntEnum):
    """a lane to broadcast from"""

    first_active_lane = 0
    specific_lane = 1

    def __str__(self):
        if self is BroadcastType.first_active_lane:
            return "first_active_lane"
        if self is BroadcastType.specific_lane:
            return "specific_lane"
        raise ValueError("Unknown BroadcastType enum entry.")



@register_attribute_builder("GPU_BroadcastType")
def _gpu_broadcasttype(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class CompilationTarget(IntEnum):
    """GPU compilation format"""

    Offload = 1
    Assembly = 2
    Binary = 3
    Fatbin = 4

    def __str__(self):
        if self is CompilationTarget.Offload:
            return "offload"
        if self is CompilationTarget.Assembly:
            return "assembly"
        if self is CompilationTarget.Binary:
            return "bin"
        if self is CompilationTarget.Fatbin:
            return "fatbin"
        raise ValueError("Unknown CompilationTarget enum entry.")



@register_attribute_builder("GPU_CompilationTargetEnum")
def _gpu_compilationtargetenum(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class Dimension(IntEnum):
    """a dimension, either 'x', 'y', or 'z'"""

    x = 0
    y = 1
    z = 2

    def __str__(self):
        if self is Dimension.x:
            return "x"
        if self is Dimension.y:
            return "y"
        if self is Dimension.z:
            return "z"
        raise ValueError("Unknown Dimension enum entry.")



@register_attribute_builder("GPU_Dimension")
def _gpu_dimension(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class Prune2To4SpMatFlag(IntEnum):
    """pruning strategy for 2:4 sparse matrix"""

    NONE = 0
    PRUNE_ONLY = 1
    PRUNE_AND_CHECK = 2

    def __str__(self):
        if self is Prune2To4SpMatFlag.NONE:
            return "NONE"
        if self is Prune2To4SpMatFlag.PRUNE_ONLY:
            return "PRUNE_ONLY"
        if self is Prune2To4SpMatFlag.PRUNE_AND_CHECK:
            return "PRUNE_AND_CHECK"
        raise ValueError("Unknown Prune2To4SpMatFlag enum entry.")



@register_attribute_builder("GPU_Prune2To4SpMatFlag")
def _gpu_prune2to4spmatflag(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class ShuffleMode(IntEnum):
    """Indexing modes supported by gpu.shuffle."""

    XOR = 0
    UP = 2
    DOWN = 1
    IDX = 3

    def __str__(self):
        if self is ShuffleMode.XOR:
            return "xor"
        if self is ShuffleMode.UP:
            return "up"
        if self is ShuffleMode.DOWN:
            return "down"
        if self is ShuffleMode.IDX:
            return "idx"
        raise ValueError("Unknown ShuffleMode enum entry.")



@register_attribute_builder("GPU_ShuffleMode")
def _gpu_shufflemode(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class SpGEMMWorkEstimationOrComputeKind(IntEnum):
    """choose whether spgemm_work_estimation_or_compute does work estimation or compute"""

    WORK_ESTIMATION = 0
    COMPUTE = 1

    def __str__(self):
        if self is SpGEMMWorkEstimationOrComputeKind.WORK_ESTIMATION:
            return "WORK_ESTIMATION"
        if self is SpGEMMWorkEstimationOrComputeKind.COMPUTE:
            return "COMPUTE"
        raise ValueError("Unknown SpGEMMWorkEstimationOrComputeKind enum entry.")



@register_attribute_builder("GPU_SpGEMMWorkEstimationOrComputeKind")
def _gpu_spgemmworkestimationorcomputekind(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class TransposeMode(IntEnum):
    """transpose mode of sparse matrix supported by sparse tensor ops"""

    NON_TRANSPOSE = 0
    TRANSPOSE = 1
    CONJUGATE_TRANSPOSE = 2

    def __str__(self):
        if self is TransposeMode.NON_TRANSPOSE:
            return "NON_TRANSPOSE"
        if self is TransposeMode.TRANSPOSE:
            return "TRANSPOSE"
        if self is TransposeMode.CONJUGATE_TRANSPOSE:
            return "CONJUGATE_TRANSPOSE"
        raise ValueError("Unknown TransposeMode enum entry.")



@register_attribute_builder("GPU_TransposeMode")
def _gpu_transposemode(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class MMAElementwiseOp(IntEnum):
    """elementwise operation to apply to mma matrix"""

    ADDF = 0
    MULF = 1
    SUBF = 2
    MAXF = 3
    MINF = 4
    DIVF = 5
    ADDI = 6
    MULI = 7
    SUBI = 8
    DIVS = 9
    DIVU = 10
    NEGATEF = 11
    NEGATES = 12
    EXTF = 13

    def __str__(self):
        if self is MMAElementwiseOp.ADDF:
            return "addf"
        if self is MMAElementwiseOp.MULF:
            return "mulf"
        if self is MMAElementwiseOp.SUBF:
            return "subf"
        if self is MMAElementwiseOp.MAXF:
            return "maxf"
        if self is MMAElementwiseOp.MINF:
            return "minf"
        if self is MMAElementwiseOp.DIVF:
            return "divf"
        if self is MMAElementwiseOp.ADDI:
            return "addi"
        if self is MMAElementwiseOp.MULI:
            return "muli"
        if self is MMAElementwiseOp.SUBI:
            return "subi"
        if self is MMAElementwiseOp.DIVS:
            return "divs"
        if self is MMAElementwiseOp.DIVU:
            return "divu"
        if self is MMAElementwiseOp.NEGATEF:
            return "negatef"
        if self is MMAElementwiseOp.NEGATES:
            return "negates"
        if self is MMAElementwiseOp.EXTF:
            return "extf"
        raise ValueError("Unknown MMAElementwiseOp enum entry.")



@register_attribute_builder("MMAElementWise")
def _mmaelementwise(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class MappingId(IntEnum):
    """Mapping ids for loop mapping"""

    DimX = 0
    DimY = 1
    DimZ = 2
    LinearDim0 = 3
    LinearDim1 = 4
    LinearDim2 = 5
    LinearDim3 = 6
    LinearDim4 = 7
    LinearDim5 = 8
    LinearDim6 = 9
    LinearDim7 = 10
    LinearDim8 = 11
    LinearDim9 = 12

    def __str__(self):
        if self is MappingId.DimX:
            return "x"
        if self is MappingId.DimY:
            return "y"
        if self is MappingId.DimZ:
            return "z"
        if self is MappingId.LinearDim0:
            return "linear_dim_0"
        if self is MappingId.LinearDim1:
            return "linear_dim_1"
        if self is MappingId.LinearDim2:
            return "linear_dim_2"
        if self is MappingId.LinearDim3:
            return "linear_dim_3"
        if self is MappingId.LinearDim4:
            return "linear_dim_4"
        if self is MappingId.LinearDim5:
            return "linear_dim_5"
        if self is MappingId.LinearDim6:
            return "linear_dim_6"
        if self is MappingId.LinearDim7:
            return "linear_dim_7"
        if self is MappingId.LinearDim8:
            return "linear_dim_8"
        if self is MappingId.LinearDim9:
            return "linear_dim_9"
        raise ValueError("Unknown MappingId enum entry.")



@register_attribute_builder("MappingIdEnum")
def _mappingidenum(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(64, context=context), int(x))

class Processor(IntEnum):
    """processor for loop mapping"""

    BlockX = 0
    BlockY = 1
    BlockZ = 2
    ThreadX = 3
    ThreadY = 4
    ThreadZ = 5
    Sequential = 6

    def __str__(self):
        if self is Processor.BlockX:
            return "block_x"
        if self is Processor.BlockY:
            return "block_y"
        if self is Processor.BlockZ:
            return "block_z"
        if self is Processor.ThreadX:
            return "thread_x"
        if self is Processor.ThreadY:
            return "thread_y"
        if self is Processor.ThreadZ:
            return "thread_z"
        if self is Processor.Sequential:
            return "sequential"
        raise ValueError("Unknown Processor enum entry.")



@register_attribute_builder("ProcessorEnum")
def _processorenum(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(64, context=context), int(x))

@register_attribute_builder("GPU_AddressSpaceAttr")
def _gpu_addressspaceattr(x, context):
    return _ods_ir.Attribute.parse(f'#gpu.address_space<{str(x)}>', context=context)

@register_attribute_builder("GPU_AllReduceOperationAttr")
def _gpu_allreduceoperationattr(x, context):
    return _ods_ir.Attribute.parse(f'#gpu<all_reduce_op {str(x)}>', context=context)

@register_attribute_builder("GPU_BroadcastTypeAttr")
def _gpu_broadcasttypeattr(x, context):
    return _ods_ir.Attribute.parse(f'#gpu<broadcast {str(x)}>', context=context)

@register_attribute_builder("GPU_DimensionAttr")
def _gpu_dimensionattr(x, context):
    return _ods_ir.Attribute.parse(f'#gpu<dim {str(x)}>', context=context)

@register_attribute_builder("GPU_Prune2To4SpMatFlagAttr")
def _gpu_prune2to4spmatflagattr(x, context):
    return _ods_ir.Attribute.parse(f'#gpu<prune_2to4_spmat_flag {str(x)}>', context=context)

@register_attribute_builder("GPU_ShuffleModeAttr")
def _gpu_shufflemodeattr(x, context):
    return _ods_ir.Attribute.parse(f'#gpu<shuffle_mode {str(x)}>', context=context)

@register_attribute_builder("GPU_SpGEMMWorkEstimationOrComputeKindAttr")
def _gpu_spgemmworkestimationorcomputekindattr(x, context):
    return _ods_ir.Attribute.parse(f'#gpu<spgemm_work_estimation_or_compute_kind {str(x)}>', context=context)

@register_attribute_builder("GPU_TransposeModeAttr")
def _gpu_transposemodeattr(x, context):
    return _ods_ir.Attribute.parse(f'#gpu<mat_transpose_mode {str(x)}>', context=context)

@register_attribute_builder("MMAElementWiseAttr")
def _mmaelementwiseattr(x, context):
    return _ods_ir.Attribute.parse(f'#gpu<mma_element_wise {str(x)}>', context=context)

