
# Autogenerated by mlir-tblgen; don't manually edit.

from ._ods_common import _cext as _ods_cext
from ._ods_common import (
    equally_sized_accessor as _ods_equally_sized_accessor,
    get_default_loc_context as _ods_get_default_loc_context,
    get_op_results_or_values as _get_op_results_or_values,
    segmented_accessor as _ods_segmented_accessor,
)
_ods_ir = _ods_cext.ir
_ods_cext.globals.register_traceback_file_exclusion(__file__)

import builtins
from typing import Sequence as _Sequence, Union as _Union, Optional as _Optional


@_ods_cext.register_dialect
class _Dialect(_ods_ir.Dialect):
  DIALECT_NAMESPACE = "builtin"

@_ods_cext.register_operation(_Dialect)
class ModuleOp(_ods_ir.OpView):
  r"""
  A `module` represents a top-level container operation. It contains a single
  [graph region](../LangRef.md#control-flow-and-ssacfg-regions) containing a single block
  which can contain any operations and does not have a terminator. Operations
  within this region cannot implicitly capture values defined outside the module,
  i.e. Modules are [IsolatedFromAbove](../Traits#isolatedfromabove). Modules have
  an optional [symbol name](../SymbolsAndSymbolTables.md) which can be used to refer
  to them in operations.
  
  Example:
  
  ```mlir
  module {
    func.func @foo()
  }
  ```
  """

  OPERATION_NAME = "builtin.module"

  _ODS_REGIONS = (1, True)

  def __init__(self, *, sym_name=None, sym_visibility=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    if sym_name is not None: attributes["sym_name"] = (sym_name if (
        isinstance(sym_name, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
          _ods_ir.AttrBuilder.get('SymbolNameAttr')(sym_name, context=_ods_context))
    if sym_visibility is not None: attributes["sym_visibility"] = (sym_visibility if (
        isinstance(sym_visibility, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(sym_visibility, context=_ods_context))
    results = []
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def sym_name(self) -> _Optional[_ods_ir.StringAttr]:
    if "sym_name" not in self.operation.attributes:
      return None
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value: _Optional[_ods_ir.StringAttr]):
    if value is not None:
      self.operation.attributes["sym_name"] = value
    elif "sym_name" in self.operation.attributes:
      del self.operation.attributes["sym_name"]

  @sym_name.deleter
  def sym_name(self):
    del self.operation.attributes["sym_name"]

  @builtins.property
  def sym_visibility(self) -> _Optional[_ods_ir.StringAttr]:
    if "sym_visibility" not in self.operation.attributes:
      return None
    return self.operation.attributes["sym_visibility"]

  @sym_visibility.setter
  def sym_visibility(self, value: _Optional[_ods_ir.StringAttr]):
    if value is not None:
      self.operation.attributes["sym_visibility"] = value
    elif "sym_visibility" in self.operation.attributes:
      del self.operation.attributes["sym_visibility"]

  @sym_visibility.deleter
  def sym_visibility(self):
    del self.operation.attributes["sym_visibility"]

  @builtins.property
  def bodyRegion(self) -> _ods_ir.Region:
    return self.regions[0]

def module(*, sym_name=None, sym_visibility=None, loc=None, ip=None) -> ModuleOp:
  return ModuleOp(sym_name=sym_name, sym_visibility=sym_visibility, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class UnrealizedConversionCastOp(_ods_ir.OpView):
  r"""
  An `unrealized_conversion_cast` operation represents an unrealized
  conversion from one set of types to another, that is used to enable the
  inter-mixing of different type systems. This operation should not be
  attributed any special representational or execution semantics, and is
  generally only intended to be used to satisfy the temporary intermixing of
  type systems during the conversion of one type system to another.
  
  This operation may produce results of arity 1-N, and accept as input
  operands of arity 0-N.
  
  Example:
  
  ```mlir
  // An unrealized 0-1 conversion. These types of conversions are useful in
  // cases where a type is removed from the type system, but not all uses have
  // been converted. For example, imagine we have a tuple type that is
  // expanded to its element types. If only some uses of an empty tuple type
  // instance are converted we still need an instance of the tuple type, but
  // have no inputs to the unrealized conversion.
  %result = unrealized_conversion_cast to !bar.tuple_type<>
  
  // An unrealized 1-1 conversion.
  %result1 = unrealized_conversion_cast %operand : !foo.type to !bar.lowered_type
  
  // An unrealized 1-N conversion.
  %results2:2 = unrealized_conversion_cast %tuple_operand : !foo.tuple_type<!foo.type, !foo.type> to !foo.type, !foo.type
  
  // An unrealized N-1 conversion.
  %result3 = unrealized_conversion_cast %operand, %operand : !foo.type, !foo.type to !bar.tuple_type<!foo.type, !foo.type>
  ```
  """

  OPERATION_NAME = "builtin.unrealized_conversion_cast"

  _ODS_REGIONS = (0, True)

  def __init__(self, outputs, inputs, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(inputs))
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.extend(outputs)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def inputs(self) -> _ods_ir.OpOperandList:
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def outputs(self) -> _ods_ir.OpResultList:
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

def unrealized_conversion_cast(outputs, inputs, *, loc=None, ip=None) -> _Union[_ods_ir.OpResult, _ods_ir.OpResultList, UnrealizedConversionCastOp]:
  op = UnrealizedConversionCastOp(outputs=outputs, inputs=inputs, loc=loc, ip=ip); results = op.results
  return results if len(results) > 1 else (results[0] if len(results) == 1 else op)
