#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecwhichequal_ VECWHICHEQUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecwhichequal_ vecwhichequal
#endif
PETSC_EXTERN void vecwhichequal_(Vec *a, Vec *b, IS *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = VecWhichEqual(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecwhichlessthan_ VECWHICHLESSTHAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecwhichlessthan_ vecwhichlessthan
#endif
PETSC_EXTERN void vecwhichlessthan_(Vec *a, Vec *b, IS *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = VecWhichLessThan(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecwhichgreaterthan_ VECWHICHGREATERTHAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecwhichgreaterthan_ vecwhichgreaterthan
#endif
PETSC_EXTERN void vecwhichgreaterthan_(Vec *a, Vec *b, IS *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = VecWhichGreaterThan(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecwhichbetween_ VECWHICHBETWEEN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecwhichbetween_ vecwhichbetween
#endif
PETSC_EXTERN void vecwhichbetween_(Vec *a, Vec *b, Vec *c, IS *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = VecWhichBetween(*a, *b, *c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecwhichbetweenorequal_ VECWHICHBETWEENOREQUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecwhichbetweenorequal_ vecwhichbetweenorequal
#endif
PETSC_EXTERN void vecwhichbetweenorequal_(Vec *a, Vec *b, Vec *c, IS *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = VecWhichBetweenOrEqual(*a, *b, *c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecwhichinactive_ VECWHICHINACTIVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecwhichinactive_ vecwhichinactive
#endif
PETSC_EXTERN void vecwhichinactive_(Vec *a, Vec *b, Vec *c, Vec *d, PetscBool *e, IS *f, PetscErrorCode *ierr)
{
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(f);
  *ierr = VecWhichInactive(*a, *b, *c, *d, *e ? PETSC_TRUE : PETSC_FALSE, f);
  if (*ierr) return;
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecisaxpy_ VECISAXPY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecisaxpy_ vecisaxpy
#endif
PETSC_EXTERN void vecisaxpy_(Vec *a, IS *b, PetscScalar *c, Vec *d, PetscErrorCode *ierr)
{
  *ierr = VecISAXPY(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define veciscopy_ VECISCOPY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define veciscopy_ veciscopy
#endif
PETSC_EXTERN void veciscopy_(Vec *a, IS *b, ScatterMode *c, Vec *d, PetscErrorCode *ierr)
{
  *ierr = VecISCopy(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecisset_ VECISSET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecisset_ vecisset
#endif
PETSC_EXTERN void vecisset_(Vec *a, IS *b, PetscScalar *c, PetscErrorCode *ierr)
{
  *ierr = VecISSet(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecisshift_ VECISSHIFT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecisshift_ vecisshift
#endif
PETSC_EXTERN void vecisshift_(Vec *a, IS *b, PetscScalar *c, PetscErrorCode *ierr)
{
  *ierr = VecISShift(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecboundgradientprojection_ VECBOUNDGRADIENTPROJECTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecboundgradientprojection_ vecboundgradientprojection
#endif
PETSC_EXTERN void vecboundgradientprojection_(Vec *a, Vec *b, Vec *c, Vec *d, Vec *e, PetscErrorCode *ierr)
{
  *ierr = VecBoundGradientProjection(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecpow_ VECPOW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecpow_ vecpow
#endif
PETSC_EXTERN void vecpow_(Vec *a, PetscScalar *b, PetscErrorCode *ierr)
{
  *ierr = VecPow(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecmedian_ VECMEDIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecmedian_ vecmedian
#endif
PETSC_EXTERN void vecmedian_(Vec *a, Vec *b, Vec *c, Vec *d, PetscErrorCode *ierr)
{
  *ierr = VecMedian(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecstepmaxbounded_ VECSTEPMAXBOUNDED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecstepmaxbounded_ vecstepmaxbounded
#endif
PETSC_EXTERN void vecstepmaxbounded_(Vec *a, Vec *b, Vec *c, Vec *d, PetscReal *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(e);
  *ierr = VecStepMaxBounded(*a, *b, *c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecstepboundinfo_ VECSTEPBOUNDINFO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecstepboundinfo_ vecstepboundinfo
#endif
PETSC_EXTERN void vecstepboundinfo_(Vec *a, Vec *b, Vec *c, Vec *d, PetscReal *e, PetscReal *f, PetscReal *g, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(e);
  CHKFORTRANNULLREAL(f);
  CHKFORTRANNULLREAL(g);
  *ierr = VecStepBoundInfo(*a, *b, *c, *d, e, f, g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecstepmax_ VECSTEPMAX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecstepmax_ vecstepmax
#endif
PETSC_EXTERN void vecstepmax_(Vec *a, Vec *b, PetscReal *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  *ierr = VecStepMax(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define iscomplementvec_ ISCOMPLEMENTVEC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define iscomplementvec_ iscomplementvec
#endif
PETSC_EXTERN void iscomplementvec_(IS *a, Vec *b, IS *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = ISComplementVec(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
