#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define veccreate_ VECCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define veccreate_ veccreate
#endif
PETSC_EXTERN void veccreate_(MPI_Fint *a, Vec *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = VecCreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define veccreatefromoptions_ VECCREATEFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define veccreatefromoptions_ veccreatefromoptions
#endif
PETSC_EXTERN void veccreatefromoptions_(MPI_Fint *a, char b[], PetscInt *c, PetscInt *d, PetscInt *e, Vec *f, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(f);
  *ierr = VecCreateFromOptions(MPI_Comm_f2c(*(a)), c_b, *c, *d, *e, f);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
}
