#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscpf.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pfstringsetfunction_ PFSTRINGSETFUNCTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pfstringsetfunction_ pfstringsetfunction
#endif
PETSC_EXTERN void pfstringsetfunction_(PF *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PFStringSetFunction(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
