#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsckdtreedestroy_ PETSCKDTREEDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsckdtreedestroy_ petsckdtreedestroy
#endif
PETSC_EXTERN void petsckdtreedestroy_(PetscKDTree *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscKDTreeDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsckdtreecreate_ PETSCKDTREECREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsckdtreecreate_ petsckdtreecreate
#endif
PETSC_EXTERN void petsckdtreecreate_(PetscCount *a, PetscInt *b, const PetscReal c[], PetscCopyMode *d, PetscInt *e, PetscKDTree *f, PetscErrorCode *ierr)
{
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(f);
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLOBJECT(f);
  *ierr = PetscKDTreeCreate(*a, *b, c, *d, *e, f);
  if (*ierr) return;
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsckdtreequerypointsnearestneighbor_ PETSCKDTREEQUERYPOINTSNEARESTNEIGHBOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsckdtreequerypointsnearestneighbor_ petsckdtreequerypointsnearestneighbor
#endif
PETSC_EXTERN void petsckdtreequerypointsnearestneighbor_(PetscKDTree *a, PetscCount *b, const PetscReal c[], PetscReal *d, PetscCount e[], PetscReal f[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLREAL(f);
  *ierr = PetscKDTreeQueryPointsNearestNeighbor(*a, *b, c, *d, e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsckdtreeview_ PETSCKDTREEVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsckdtreeview_ petsckdtreeview
#endif
PETSC_EXTERN void petsckdtreeview_(PetscKDTree *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = PetscKDTreeView(*a, v_b);
  if (*ierr) return;
}
