#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define isequal_ ISEQUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define isequal_ isequal
#endif
PETSC_EXTERN void isequal_(IS *a, IS *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(c);
  *ierr = ISEqual(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define isequalunsorted_ ISEQUALUNSORTED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define isequalunsorted_ isequalunsorted
#endif
PETSC_EXTERN void isequalunsorted_(IS *a, IS *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(c);
  *ierr = ISEqualUnsorted(*a, *b, c);
  if (*ierr) return;
}
