#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define iscompressindicesgeneral_ ISCOMPRESSINDICESGENERAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define iscompressindicesgeneral_ iscompressindicesgeneral
#endif
PETSC_EXTERN void iscompressindicesgeneral_(PetscInt *a, PetscInt *b, PetscInt *c, PetscInt *d, const IS e[], IS f[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLOBJECT(e);
  CHKFORTRANNULLOBJECT(f);
  *ierr = ISCompressIndicesGeneral(*a, *b, *c, *d, e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define isexpandindicesgeneral_ ISEXPANDINDICESGENERAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define isexpandindicesgeneral_ isexpandindicesgeneral
#endif
PETSC_EXTERN void isexpandindicesgeneral_(PetscInt *a, PetscInt *b, PetscInt *c, PetscInt *d, const IS e[], IS f[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLOBJECT(e);
  CHKFORTRANNULLOBJECT(f);
  *ierr = ISExpandIndicesGeneral(*a, *b, *c, *d, e, f);
  if (*ierr) return;
}
