#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define isrenumber_ ISRENUMBER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define isrenumber_ isrenumber
#endif
PETSC_EXTERN void isrenumber_(IS *a, IS *b, PetscInt *c, IS *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLOBJECT(d);
  *ierr = ISRenumber(*a, *b, c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define iscreatesubis_ ISCREATESUBIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define iscreatesubis_ iscreatesubis
#endif
PETSC_EXTERN void iscreatesubis_(IS *a, IS *b, IS *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = ISCreateSubIS(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define isclearinfocache_ ISCLEARINFOCACHE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define isclearinfocache_ isclearinfocache
#endif
PETSC_EXTERN void isclearinfocache_(IS *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = ISClearInfoCache(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define issetinfo_ ISSETINFO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define issetinfo_ issetinfo
#endif
PETSC_EXTERN void issetinfo_(IS *a, ISInfo *b, ISInfoType *c, PetscBool *d, PetscBool *e, PetscErrorCode *ierr)
{
  *ierr = ISSetInfo(*a, *b, *c, *d ? PETSC_TRUE : PETSC_FALSE, *e ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define isgetinfo_ ISGETINFO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define isgetinfo_ isgetinfo
#endif
PETSC_EXTERN void isgetinfo_(IS *a, ISInfo *b, ISInfoType *c, PetscBool *d, PetscBool *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(e);
  *ierr = ISGetInfo(*a, *b, *c, *d ? PETSC_TRUE : PETSC_FALSE, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define isidentity_ ISIDENTITY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define isidentity_ isidentity
#endif
PETSC_EXTERN void isidentity_(IS *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = ISIdentity(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define issetidentity_ ISSETIDENTITY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define issetidentity_ issetidentity
#endif
PETSC_EXTERN void issetidentity_(IS *a, PetscErrorCode *ierr)
{
  *ierr = ISSetIdentity(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define iscontiguouslocal_ ISCONTIGUOUSLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define iscontiguouslocal_ iscontiguouslocal
#endif
PETSC_EXTERN void iscontiguouslocal_(IS *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscBool *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLBOOL(e);
  *ierr = ISContiguousLocal(*a, *b, *c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define ispermutation_ ISPERMUTATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define ispermutation_ ispermutation
#endif
PETSC_EXTERN void ispermutation_(IS *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = ISPermutation(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define issetpermutation_ ISSETPERMUTATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define issetpermutation_ issetpermutation
#endif
PETSC_EXTERN void issetpermutation_(IS *a, PetscErrorCode *ierr)
{
  *ierr = ISSetPermutation(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define isdestroy_ ISDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define isdestroy_ isdestroy
#endif
PETSC_EXTERN void isdestroy_(IS *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = ISDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define isinvertpermutation_ ISINVERTPERMUTATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define isinvertpermutation_ isinvertpermutation
#endif
PETSC_EXTERN void isinvertpermutation_(IS *a, PetscInt *b, IS *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = ISInvertPermutation(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define isgetsize_ ISGETSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define isgetsize_ isgetsize
#endif
PETSC_EXTERN void isgetsize_(IS *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = ISGetSize(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define isgetlocalsize_ ISGETLOCALSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define isgetlocalsize_ isgetlocalsize
#endif
PETSC_EXTERN void isgetlocalsize_(IS *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = ISGetLocalSize(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define isgetlayout_ ISGETLAYOUT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define isgetlayout_ isgetlayout
#endif
PETSC_EXTERN void isgetlayout_(IS *a, PetscLayout *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = ISGetLayout(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define issetlayout_ ISSETLAYOUT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define issetlayout_ issetlayout
#endif
PETSC_EXTERN void issetlayout_(IS *a, PetscLayout *b, PetscErrorCode *ierr)
{
  *ierr = ISSetLayout(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define isgetminmax_ ISGETMINMAX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define isgetminmax_ isgetminmax
#endif
PETSC_EXTERN void isgetminmax_(IS *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = ISGetMinMax(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define islocate_ ISLOCATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define islocate_ islocate
#endif
PETSC_EXTERN void islocate_(IS *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = ISLocate(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define isgetnonlocalis_ ISGETNONLOCALIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define isgetnonlocalis_ isgetnonlocalis
#endif
PETSC_EXTERN void isgetnonlocalis_(IS *a, IS *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = ISGetNonlocalIS(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define isrestorenonlocalis_ ISRESTORENONLOCALIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define isrestorenonlocalis_ isrestorenonlocalis
#endif
PETSC_EXTERN void isrestorenonlocalis_(IS *a, IS *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = ISRestoreNonlocalIS(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define isviewfromoptions_ ISVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define isviewfromoptions_ isviewfromoptions
#endif
PETSC_EXTERN void isviewfromoptions_(IS *a, PetscObject *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = ISViewFromOptions(*a, *b, c_c);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define isview_ ISVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define isview_ isview
#endif
PETSC_EXTERN void isview_(IS *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = ISView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define isload_ ISLOAD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define isload_ isload
#endif
PETSC_EXTERN void isload_(IS *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = ISLoad(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define issort_ ISSORT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define issort_ issort
#endif
PETSC_EXTERN void issort_(IS *a, PetscErrorCode *ierr)
{
  *ierr = ISSort(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define issortremovedups_ ISSORTREMOVEDUPS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define issortremovedups_ issortremovedups
#endif
PETSC_EXTERN void issortremovedups_(IS *a, PetscErrorCode *ierr)
{
  *ierr = ISSortRemoveDups(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define istogeneral_ ISTOGENERAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define istogeneral_ istogeneral
#endif
PETSC_EXTERN void istogeneral_(IS *a, PetscErrorCode *ierr)
{
  *ierr = ISToGeneral(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define issorted_ ISSORTED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define issorted_ issorted
#endif
PETSC_EXTERN void issorted_(IS *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = ISSorted(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define isduplicate_ ISDUPLICATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define isduplicate_ isduplicate
#endif
PETSC_EXTERN void isduplicate_(IS *a, IS *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = ISDuplicate(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define iscopy_ ISCOPY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define iscopy_ iscopy
#endif
PETSC_EXTERN void iscopy_(IS *a, IS *b, PetscErrorCode *ierr)
{
  *ierr = ISCopy(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define isshift_ ISSHIFT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define isshift_ isshift
#endif
PETSC_EXTERN void isshift_(IS *a, PetscInt *b, IS *c, PetscErrorCode *ierr)
{
  *ierr = ISShift(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define isoncomm_ ISONCOMM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define isoncomm_ isoncomm
#endif
PETSC_EXTERN void isoncomm_(IS *a, MPI_Fint *b, PetscCopyMode *c, IS *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = ISOnComm(*a, MPI_Comm_f2c(*(b)), *c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define issetblocksize_ ISSETBLOCKSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define issetblocksize_ issetblocksize
#endif
PETSC_EXTERN void issetblocksize_(IS *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = ISSetBlockSize(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define isgetblocksize_ ISGETBLOCKSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define isgetblocksize_ isgetblocksize
#endif
PETSC_EXTERN void isgetblocksize_(IS *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = ISGetBlockSize(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define issetcompressoutput_ ISSETCOMPRESSOUTPUT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define issetcompressoutput_ issetcompressoutput
#endif
PETSC_EXTERN void issetcompressoutput_(IS *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = ISSetCompressOutput(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define isgetcompressoutput_ ISGETCOMPRESSOUTPUT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define isgetcompressoutput_ isgetcompressoutput
#endif
PETSC_EXTERN void isgetcompressoutput_(IS *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = ISGetCompressOutput(*a, b);
  if (*ierr) return;
}
