#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define iscreategeneral_ ISCREATEGENERAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define iscreategeneral_ iscreategeneral
#endif
PETSC_EXTERN void iscreategeneral_(MPI_Fint *a, PetscInt *b, const PetscInt c[], PetscCopyMode *d, IS *e, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLOBJECT(e);
  *ierr = ISCreateGeneral(MPI_Comm_f2c(*(a)), *b, c, *d, e);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define isgeneralsetindices_ ISGENERALSETINDICES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define isgeneralsetindices_ isgeneralsetindices
#endif
PETSC_EXTERN void isgeneralsetindices_(IS *a, PetscInt *b, const PetscInt c[], PetscCopyMode *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = ISGeneralSetIndices(*a, *b, c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define isgeneralsetindicesfrommask_ ISGENERALSETINDICESFROMMASK
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define isgeneralsetindicesfrommask_ isgeneralsetindicesfrommask
#endif
PETSC_EXTERN void isgeneralsetindicesfrommask_(IS *a, PetscInt *b, PetscInt *c, const PetscBool d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(d);
  *ierr = ISGeneralSetIndicesFromMask(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define isgeneralfilter_ ISGENERALFILTER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define isgeneralfilter_ isgeneralfilter
#endif
PETSC_EXTERN void isgeneralfilter_(IS *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  *ierr = ISGeneralFilter(*a, *b, *c);
  if (*ierr) return;
}
