#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define aofinalizepackage_ AOFINALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define aofinalizepackage_ aofinalizepackage
#endif
PETSC_EXTERN void aofinalizepackage_(PetscErrorCode *ierr)
{
  *ierr = AOFinalizePackage();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define aoinitializepackage_ AOINITIALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define aoinitializepackage_ aoinitializepackage
#endif
PETSC_EXTERN void aoinitializepackage_(PetscErrorCode *ierr)
{
  *ierr = AOInitializePackage();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define aosettype_ AOSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define aosettype_ aosettype
#endif
PETSC_EXTERN void aosettype_(AO *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = AOSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define aogettype_ AOGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define aogettype_ aogettype
#endif
PETSC_EXTERN void aogettype_(AO *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = AOGetType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define aoregisterall_ AOREGISTERALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define aoregisterall_ aoregisterall
#endif
PETSC_EXTERN void aoregisterall_(PetscErrorCode *ierr)
{
  *ierr = AORegisterAll();
  if (*ierr) return;
}
