#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define aomappinghasapplicationindex_ AOMAPPINGHASAPPLICATIONINDEX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define aomappinghasapplicationindex_ aomappinghasapplicationindex
#endif
PETSC_EXTERN void aomappinghasapplicationindex_(AO *a, PetscInt *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(c);
  *ierr = AOMappingHasApplicationIndex(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define aomappinghaspetscindex_ AOMAPPINGHASPETSCINDEX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define aomappinghaspetscindex_ aomappinghaspetscindex
#endif
PETSC_EXTERN void aomappinghaspetscindex_(AO *a, PetscInt *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(c);
  *ierr = AOMappingHasPetscIndex(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define aocreatemapping_ AOCREATEMAPPING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define aocreatemapping_ aocreatemapping
#endif
PETSC_EXTERN void aocreatemapping_(MPI_Fint *a, PetscInt *b, const PetscInt c[], const PetscInt d[], AO *e, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLOBJECT(e);
  *ierr = AOCreateMapping(MPI_Comm_f2c(*(a)), *b, c, d, e);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define aocreatemappingis_ AOCREATEMAPPINGIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define aocreatemappingis_ aocreatemappingis
#endif
PETSC_EXTERN void aocreatemappingis_(IS *a, IS *b, AO *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = AOCreateMappingIS(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
