  type, extends(tPetscObject) ::  tTS
  end type tTS
  TS, parameter :: PETSC_NULL_TS = tTS(0)
  TS, target :: PETSC_NULL_TS_ARRAY(1) = [tTS(0)]
  TS, pointer :: PETSC_NULL_TS_POINTER(:) => PETSC_NULL_TS_ARRAY
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TS
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TS_ARRAY
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TS_POINTER
#endif

  type, extends(tPetscObject) ::  tTSTrajectory
  end type tTSTrajectory
  TSTrajectory, parameter :: PETSC_NULL_TSTRAJECTORY = tTSTrajectory(0)
  TSTrajectory, target :: PETSC_NULL_TSTRAJECTORY_ARRAY(1) = [tTSTrajectory(0)]
  TSTrajectory, pointer :: PETSC_NULL_TSTRAJECTORY_POINTER(:) => PETSC_NULL_TSTRAJECTORY_ARRAY
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSTRAJECTORY
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSTRAJECTORY_ARRAY
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSTRAJECTORY_POINTER
#endif

  type tTSMonitorDrawCtx
    PetscFortranAddr:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type tTSMonitorDrawCtx
  TSMonitorDrawCtx, parameter :: PETSC_NULL_TSMONITORDRAWCTX = tTSMonitorDrawCtx(0)
  TSMonitorDrawCtx, target :: PETSC_NULL_TSMONITORDRAWCTX_ARRAY(1) = [tTSMonitorDrawCtx(0)]
  TSMonitorDrawCtx, pointer :: PETSC_NULL_TSMONITORDRAWCTX_POINTER(:) => PETSC_NULL_TSMONITORDRAWCTX_ARRAY
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSMONITORDRAWCTX
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSMONITORDRAWCTX_ARRAY
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSMONITORDRAWCTX_POINTER
#endif

  type tTSMonitorSolutionCtx
    PetscFortranAddr:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type tTSMonitorSolutionCtx
  TSMonitorSolutionCtx, parameter :: PETSC_NULL_TSMONITORSOLUTIONCTX = tTSMonitorSolutionCtx(0)
  TSMonitorSolutionCtx, target :: PETSC_NULL_TSMONITORSOLUTIONCTX_ARRAY(1) = [tTSMonitorSolutionCtx(0)]
  TSMonitorSolutionCtx, pointer :: PETSC_NULL_TSMONITORSOLUTIONCTX_POINTER(:) => PETSC_NULL_TSMONITORSOLUTIONCTX_ARRAY
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSMONITORSOLUTIONCTX
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSMONITORSOLUTIONCTX_ARRAY
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSMONITORSOLUTIONCTX_POINTER
#endif

  type tTSMonitorVTKCtx
    PetscFortranAddr:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type tTSMonitorVTKCtx
  TSMonitorVTKCtx, parameter :: PETSC_NULL_TSMONITORVTKCTX = tTSMonitorVTKCtx(0)
  TSMonitorVTKCtx, target :: PETSC_NULL_TSMONITORVTKCTX_ARRAY(1) = [tTSMonitorVTKCtx(0)]
  TSMonitorVTKCtx, pointer :: PETSC_NULL_TSMONITORVTKCTX_POINTER(:) => PETSC_NULL_TSMONITORVTKCTX_ARRAY
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSMONITORVTKCTX
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSMONITORVTKCTX_ARRAY
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSMONITORVTKCTX_POINTER
#endif

  type tTSMonitorLGCtx
    PetscFortranAddr:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type tTSMonitorLGCtx
  TSMonitorLGCtx, parameter :: PETSC_NULL_TSMONITORLGCTX = tTSMonitorLGCtx(0)
  TSMonitorLGCtx, target :: PETSC_NULL_TSMONITORLGCTX_ARRAY(1) = [tTSMonitorLGCtx(0)]
  TSMonitorLGCtx, pointer :: PETSC_NULL_TSMONITORLGCTX_POINTER(:) => PETSC_NULL_TSMONITORLGCTX_ARRAY
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSMONITORLGCTX
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSMONITORLGCTX_ARRAY
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSMONITORLGCTX_POINTER
#endif

  type tTSMonitorLGCtxNetwork
    PetscFortranAddr:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type tTSMonitorLGCtxNetwork
  TSMonitorLGCtxNetwork, parameter :: PETSC_NULL_TSMONITORLGCTXNETWORK = tTSMonitorLGCtxNetwork(0)
  TSMonitorLGCtxNetwork, target :: PETSC_NULL_TSMONITORLGCTXNETWORK_ARRAY(1) = [tTSMonitorLGCtxNetwork(0)]
  TSMonitorLGCtxNetwork, pointer :: PETSC_NULL_TSMONITORLGCTXNETWORK_POINTER(:) => PETSC_NULL_TSMONITORLGCTXNETWORK_ARRAY
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSMONITORLGCTXNETWORK
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSMONITORLGCTXNETWORK_ARRAY
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSMONITORLGCTXNETWORK_POINTER
#endif

  type tTSMonitorEnvelopeCtx
    PetscFortranAddr:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type tTSMonitorEnvelopeCtx
  TSMonitorEnvelopeCtx, parameter :: PETSC_NULL_TSMONITORENVELOPECTX = tTSMonitorEnvelopeCtx(0)
  TSMonitorEnvelopeCtx, target :: PETSC_NULL_TSMONITORENVELOPECTX_ARRAY(1) = [tTSMonitorEnvelopeCtx(0)]
  TSMonitorEnvelopeCtx, pointer :: PETSC_NULL_TSMONITORENVELOPECTX_POINTER(:) => PETSC_NULL_TSMONITORENVELOPECTX_ARRAY
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSMONITORENVELOPECTX
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSMONITORENVELOPECTX_ARRAY
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSMONITORENVELOPECTX_POINTER
#endif

  type tTSMonitorSPEigCtx
    PetscFortranAddr:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type tTSMonitorSPEigCtx
  TSMonitorSPEigCtx, parameter :: PETSC_NULL_TSMONITORSPEIGCTX = tTSMonitorSPEigCtx(0)
  TSMonitorSPEigCtx, target :: PETSC_NULL_TSMONITORSPEIGCTX_ARRAY(1) = [tTSMonitorSPEigCtx(0)]
  TSMonitorSPEigCtx, pointer :: PETSC_NULL_TSMONITORSPEIGCTX_POINTER(:) => PETSC_NULL_TSMONITORSPEIGCTX_ARRAY
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSMONITORSPEIGCTX
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSMONITORSPEIGCTX_ARRAY
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSMONITORSPEIGCTX_POINTER
#endif

  type tTSMonitorSPCtx
    PetscFortranAddr:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type tTSMonitorSPCtx
  TSMonitorSPCtx, parameter :: PETSC_NULL_TSMONITORSPCTX = tTSMonitorSPCtx(0)
  TSMonitorSPCtx, target :: PETSC_NULL_TSMONITORSPCTX_ARRAY(1) = [tTSMonitorSPCtx(0)]
  TSMonitorSPCtx, pointer :: PETSC_NULL_TSMONITORSPCTX_POINTER(:) => PETSC_NULL_TSMONITORSPCTX_ARRAY
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSMONITORSPCTX
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSMONITORSPCTX_ARRAY
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSMONITORSPCTX_POINTER
#endif

  type tTSMonitorHGCtx
    PetscFortranAddr:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type tTSMonitorHGCtx
  TSMonitorHGCtx, parameter :: PETSC_NULL_TSMONITORHGCTX = tTSMonitorHGCtx(0)
  TSMonitorHGCtx, target :: PETSC_NULL_TSMONITORHGCTX_ARRAY(1) = [tTSMonitorHGCtx(0)]
  TSMonitorHGCtx, pointer :: PETSC_NULL_TSMONITORHGCTX_POINTER(:) => PETSC_NULL_TSMONITORHGCTX_ARRAY
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSMONITORHGCTX
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSMONITORHGCTX_ARRAY
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSMONITORHGCTX_POINTER
#endif

  type, extends(tPetscObject) ::  tTSAdapt
  end type tTSAdapt
  TSAdapt, parameter :: PETSC_NULL_TSADAPT = tTSAdapt(0)
  TSAdapt, target :: PETSC_NULL_TSADAPT_ARRAY(1) = [tTSAdapt(0)]
  TSAdapt, pointer :: PETSC_NULL_TSADAPT_POINTER(:) => PETSC_NULL_TSADAPT_ARRAY
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSADAPT
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSADAPT_ARRAY
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSADAPT_POINTER
#endif

  type, extends(tPetscObject) ::  tTSGLLEAdapt
  end type tTSGLLEAdapt
  TSGLLEAdapt, parameter :: PETSC_NULL_TSGLLEADAPT = tTSGLLEAdapt(0)
  TSGLLEAdapt, target :: PETSC_NULL_TSGLLEADAPT_ARRAY(1) = [tTSGLLEAdapt(0)]
  TSGLLEAdapt, pointer :: PETSC_NULL_TSGLLEADAPT_POINTER(:) => PETSC_NULL_TSGLLEADAPT_ARRAY
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSGLLEADAPT
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSGLLEADAPT_ARRAY
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSGLLEADAPT_POINTER
#endif

  type eTSProblemType
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type eTSProblemType

  TSProblemType, parameter :: PETSC_NULL_TSPROBLEMTYPE = eTSProblemType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSPROBLEMTYPE
#endif
    TSProblemType, parameter :: TS_LINEAR = eTSProblemType(0)
    TSProblemType, parameter :: TS_NONLINEAR = eTSProblemType(1)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::TS_LINEAR
!DEC$ ATTRIBUTES DLLEXPORT::TS_NONLINEAR
#endif

  type eTSEquationType
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type eTSEquationType

  TSEquationType, parameter :: PETSC_NULL_TSEQUATIONTYPE = eTSEquationType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSEQUATIONTYPE
#endif
    TSEquationType, parameter :: TS_EQ_UNSPECIFIED = eTSEquationType(-1)
    TSEquationType, parameter :: TS_EQ_EXPLICIT = eTSEquationType(0)
    TSEquationType, parameter :: TS_EQ_ODE_EXPLICIT = eTSEquationType(1)
    TSEquationType, parameter :: TS_EQ_DAE_SEMI_EXPLICIT_INDEX1 = eTSEquationType(100)
    TSEquationType, parameter :: TS_EQ_DAE_SEMI_EXPLICIT_INDEX2 = eTSEquationType(200)
    TSEquationType, parameter :: TS_EQ_DAE_SEMI_EXPLICIT_INDEX3 = eTSEquationType(300)
    TSEquationType, parameter :: TS_EQ_DAE_SEMI_EXPLICIT_INDEXHI = eTSEquationType(500)
    TSEquationType, parameter :: TS_EQ_IMPLICIT = eTSEquationType(1000)
    TSEquationType, parameter :: TS_EQ_ODE_IMPLICIT = eTSEquationType(1001)
    TSEquationType, parameter :: TS_EQ_DAE_IMPLICIT_INDEX1 = eTSEquationType(1100)
    TSEquationType, parameter :: TS_EQ_DAE_IMPLICIT_INDEX2 = eTSEquationType(1200)
    TSEquationType, parameter :: TS_EQ_DAE_IMPLICIT_INDEX3 = eTSEquationType(1300)
    TSEquationType, parameter :: TS_EQ_DAE_IMPLICIT_INDEXHI = eTSEquationType(1500)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::TS_EQ_UNSPECIFIED 
!DEC$ ATTRIBUTES DLLEXPORT::TS_EQ_EXPLICIT 
!DEC$ ATTRIBUTES DLLEXPORT::TS_EQ_ODE_EXPLICIT 
!DEC$ ATTRIBUTES DLLEXPORT::TS_EQ_DAE_SEMI_EXPLICIT_INDEX1 
!DEC$ ATTRIBUTES DLLEXPORT::TS_EQ_DAE_SEMI_EXPLICIT_INDEX2 
!DEC$ ATTRIBUTES DLLEXPORT::TS_EQ_DAE_SEMI_EXPLICIT_INDEX3 
!DEC$ ATTRIBUTES DLLEXPORT::TS_EQ_DAE_SEMI_EXPLICIT_INDEXHI 
!DEC$ ATTRIBUTES DLLEXPORT::TS_EQ_IMPLICIT 
!DEC$ ATTRIBUTES DLLEXPORT::TS_EQ_ODE_IMPLICIT 
!DEC$ ATTRIBUTES DLLEXPORT::TS_EQ_DAE_IMPLICIT_INDEX1 
!DEC$ ATTRIBUTES DLLEXPORT::TS_EQ_DAE_IMPLICIT_INDEX2 
!DEC$ ATTRIBUTES DLLEXPORT::TS_EQ_DAE_IMPLICIT_INDEX3 
!DEC$ ATTRIBUTES DLLEXPORT::TS_EQ_DAE_IMPLICIT_INDEXHI 
#endif

  type eTSConvergedReason
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type eTSConvergedReason

  TSConvergedReason, parameter :: PETSC_NULL_TSCONVERGEDREASON = eTSConvergedReason(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSCONVERGEDREASON
#endif
    TSConvergedReason, parameter :: TS_CONVERGED_ITERATING = eTSConvergedReason(0)
    TSConvergedReason, parameter :: TS_CONVERGED_TIME = eTSConvergedReason(1)
    TSConvergedReason, parameter :: TS_CONVERGED_ITS = eTSConvergedReason(2)
    TSConvergedReason, parameter :: TS_CONVERGED_USER = eTSConvergedReason(3)
    TSConvergedReason, parameter :: TS_CONVERGED_EVENT = eTSConvergedReason(4)
    TSConvergedReason, parameter :: TS_CONVERGED_PSEUDO_FATOL = eTSConvergedReason(5)
    TSConvergedReason, parameter :: TS_CONVERGED_PSEUDO_FRTOL = eTSConvergedReason(6)
    TSConvergedReason, parameter :: TS_DIVERGED_NONLINEAR_SOLVE = eTSConvergedReason(-1)
    TSConvergedReason, parameter :: TS_DIVERGED_STEP_REJECTED = eTSConvergedReason(-2)
    TSConvergedReason, parameter :: TSFORWARD_DIVERGED_LINEAR_SOLVE = eTSConvergedReason(-3)
    TSConvergedReason, parameter :: TSADJOINT_DIVERGED_LINEAR_SOLVE = eTSConvergedReason(-4)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::TS_CONVERGED_ITERATING 
!DEC$ ATTRIBUTES DLLEXPORT::TS_CONVERGED_TIME 
!DEC$ ATTRIBUTES DLLEXPORT::TS_CONVERGED_ITS 
!DEC$ ATTRIBUTES DLLEXPORT::TS_CONVERGED_USER 
!DEC$ ATTRIBUTES DLLEXPORT::TS_CONVERGED_EVENT 
!DEC$ ATTRIBUTES DLLEXPORT::TS_CONVERGED_PSEUDO_FATOL 
!DEC$ ATTRIBUTES DLLEXPORT::TS_CONVERGED_PSEUDO_FRTOL 
!DEC$ ATTRIBUTES DLLEXPORT::TS_DIVERGED_NONLINEAR_SOLVE 
!DEC$ ATTRIBUTES DLLEXPORT::TS_DIVERGED_STEP_REJECTED 
!DEC$ ATTRIBUTES DLLEXPORT::TSFORWARD_DIVERGED_LINEAR_SOLVE 
!DEC$ ATTRIBUTES DLLEXPORT::TSADJOINT_DIVERGED_LINEAR_SOLVE 
#endif

  type eTSExactFinalTimeOption
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type eTSExactFinalTimeOption

  TSExactFinalTimeOption, parameter :: PETSC_NULL_TSEXACTFINALTIMEOPTION = eTSExactFinalTimeOption(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSEXACTFINALTIMEOPTION
#endif
    TSExactFinalTimeOption, parameter :: TS_EXACTFINALTIME_UNSPECIFIED = eTSExactFinalTimeOption(0)
    TSExactFinalTimeOption, parameter :: TS_EXACTFINALTIME_STEPOVER = eTSExactFinalTimeOption(1)
    TSExactFinalTimeOption, parameter :: TS_EXACTFINALTIME_INTERPOLATE = eTSExactFinalTimeOption(2)
    TSExactFinalTimeOption, parameter :: TS_EXACTFINALTIME_MATCHSTEP = eTSExactFinalTimeOption(3)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::TS_EXACTFINALTIME_UNSPECIFIED 
!DEC$ ATTRIBUTES DLLEXPORT::TS_EXACTFINALTIME_STEPOVER 
!DEC$ ATTRIBUTES DLLEXPORT::TS_EXACTFINALTIME_INTERPOLATE 
!DEC$ ATTRIBUTES DLLEXPORT::TS_EXACTFINALTIME_MATCHSTEP 
#endif

  type eTSTrajectoryMemoryType
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type eTSTrajectoryMemoryType

  TSTrajectoryMemoryType, parameter :: PETSC_NULL_TSTRAJECTORYMEMORYTYPE = eTSTrajectoryMemoryType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSTRAJECTORYMEMORYTYPE
#endif
    TSTrajectoryMemoryType, parameter :: TJ_REVOLVE = eTSTrajectoryMemoryType(0)
    TSTrajectoryMemoryType, parameter :: TJ_CAMS = eTSTrajectoryMemoryType(1)
    TSTrajectoryMemoryType, parameter :: TJ_PETSC = eTSTrajectoryMemoryType(2)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::TJ_REVOLVE
!DEC$ ATTRIBUTES DLLEXPORT::TJ_CAMS
!DEC$ ATTRIBUTES DLLEXPORT::TJ_PETSC
#endif

  type eTSDGType
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type eTSDGType

  TSDGType, parameter :: PETSC_NULL_TSDGTYPE = eTSDGType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSDGTYPE
#endif
    TSDGType, parameter :: TS_DG_GONZALEZ = eTSDGType(0)
    TSDGType, parameter :: TS_DG_AVERAGE = eTSDGType(1)
    TSDGType, parameter :: TS_DG_NONE = eTSDGType(2)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::TS_DG_GONZALEZ
!DEC$ ATTRIBUTES DLLEXPORT::TS_DG_AVERAGE
!DEC$ ATTRIBUTES DLLEXPORT::TS_DG_NONE
#endif

  type eTSSundialsLmmType
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type eTSSundialsLmmType

  TSSundialsLmmType, parameter :: PETSC_NULL_TSSUNDIALSLMMTYPE = eTSSundialsLmmType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSSUNDIALSLMMTYPE
#endif
    TSSundialsLmmType, parameter :: SUNDIALS_ADAMS = eTSSundialsLmmType(1)
    TSSundialsLmmType, parameter :: SUNDIALS_BDF = eTSSundialsLmmType(2)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::SUNDIALS_ADAMS 
!DEC$ ATTRIBUTES DLLEXPORT::SUNDIALS_BDF 
#endif

  type eTSSundialsGramSchmidtType
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type eTSSundialsGramSchmidtType

  TSSundialsGramSchmidtType, parameter :: PETSC_NULL_TSSUNDIALSGRAMSCHMIDTTYPE = eTSSundialsGramSchmidtType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TSSUNDIALSGRAMSCHMIDTTYPE
#endif
    TSSundialsGramSchmidtType, parameter :: SUNDIALS_MODIFIED_GS = eTSSundialsGramSchmidtType(1)
    TSSundialsGramSchmidtType, parameter :: SUNDIALS_CLASSICAL_GS = eTSSundialsGramSchmidtType(2)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::SUNDIALS_MODIFIED_GS 
!DEC$ ATTRIBUTES DLLEXPORT::SUNDIALS_CLASSICAL_GS 
#endif

  CHARACTER(LEN=*), PARAMETER :: TSEULER = 'euler'
  CHARACTER(LEN=*), PARAMETER :: TSBEULER = 'beuler'
  CHARACTER(LEN=*), PARAMETER :: TSBASICSYMPLECTIC = 'basicsymplectic'
  CHARACTER(LEN=*), PARAMETER :: TSPSEUDO = 'pseudo'
  CHARACTER(LEN=*), PARAMETER :: TSCN = 'cn'
  CHARACTER(LEN=*), PARAMETER :: TSSUNDIALS = 'sundials'
  CHARACTER(LEN=*), PARAMETER :: TSRK = 'rk'
  CHARACTER(LEN=*), PARAMETER :: TSPYTHON = 'python'
  CHARACTER(LEN=*), PARAMETER :: TSTHETA = 'theta'
  CHARACTER(LEN=*), PARAMETER :: TSALPHA = 'alpha'
  CHARACTER(LEN=*), PARAMETER :: TSALPHA2 = 'alpha2'
  CHARACTER(LEN=*), PARAMETER :: TSGLLE = 'glle'
  CHARACTER(LEN=*), PARAMETER :: TSGLEE = 'glee'
  CHARACTER(LEN=*), PARAMETER :: TSSSP = 'ssp'
  CHARACTER(LEN=*), PARAMETER :: TSARKIMEX = 'arkimex'
  CHARACTER(LEN=*), PARAMETER :: TSROSW = 'rosw'
  CHARACTER(LEN=*), PARAMETER :: TSEIMEX = 'eimex'
  CHARACTER(LEN=*), PARAMETER :: TSMIMEX = 'mimex'
  CHARACTER(LEN=*), PARAMETER :: TSBDF = 'bdf'
  CHARACTER(LEN=*), PARAMETER :: TSRADAU5 = 'radau5'
  CHARACTER(LEN=*), PARAMETER :: TSMPRK = 'mprk'
  CHARACTER(LEN=*), PARAMETER :: TSDISCGRAD = 'discgrad'
  CHARACTER(LEN=*), PARAMETER :: TSIRK = 'irk'
  CHARACTER(LEN=*), PARAMETER :: TSDIRK = 'dirk'

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::TSEULER
!DEC$ ATTRIBUTES DLLEXPORT::TSBEULER
!DEC$ ATTRIBUTES DLLEXPORT::TSBASICSYMPLECTIC
!DEC$ ATTRIBUTES DLLEXPORT::TSPSEUDO
!DEC$ ATTRIBUTES DLLEXPORT::TSCN
!DEC$ ATTRIBUTES DLLEXPORT::TSSUNDIALS
!DEC$ ATTRIBUTES DLLEXPORT::TSRK
!DEC$ ATTRIBUTES DLLEXPORT::TSPYTHON
!DEC$ ATTRIBUTES DLLEXPORT::TSTHETA
!DEC$ ATTRIBUTES DLLEXPORT::TSALPHA
!DEC$ ATTRIBUTES DLLEXPORT::TSALPHA2
!DEC$ ATTRIBUTES DLLEXPORT::TSGLLE
!DEC$ ATTRIBUTES DLLEXPORT::TSGLEE
!DEC$ ATTRIBUTES DLLEXPORT::TSSSP
!DEC$ ATTRIBUTES DLLEXPORT::TSARKIMEX
!DEC$ ATTRIBUTES DLLEXPORT::TSROSW
!DEC$ ATTRIBUTES DLLEXPORT::TSEIMEX
!DEC$ ATTRIBUTES DLLEXPORT::TSMIMEX
!DEC$ ATTRIBUTES DLLEXPORT::TSBDF
!DEC$ ATTRIBUTES DLLEXPORT::TSRADAU5
!DEC$ ATTRIBUTES DLLEXPORT::TSMPRK
!DEC$ ATTRIBUTES DLLEXPORT::TSDISCGRAD
!DEC$ ATTRIBUTES DLLEXPORT::TSIRK
!DEC$ ATTRIBUTES DLLEXPORT::TSDIRK
#endif

  CHARACTER(LEN=*), PARAMETER :: TSTRAJECTORYBASIC = 'basic'
  CHARACTER(LEN=*), PARAMETER :: TSTRAJECTORYSINGLEFILE = 'singlefile'
  CHARACTER(LEN=*), PARAMETER :: TSTRAJECTORYMEMORY = 'memory'
  CHARACTER(LEN=*), PARAMETER :: TSTRAJECTORYVISUALIZATION = 'visualization'

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::TSTRAJECTORYBASIC
!DEC$ ATTRIBUTES DLLEXPORT::TSTRAJECTORYSINGLEFILE
!DEC$ ATTRIBUTES DLLEXPORT::TSTRAJECTORYMEMORY
!DEC$ ATTRIBUTES DLLEXPORT::TSTRAJECTORYVISUALIZATION
#endif

  CHARACTER(LEN=*), PARAMETER :: TSSSPRKS2 = 'rks2'
  CHARACTER(LEN=*), PARAMETER :: TSSSPRKS3 = 'rks3'
  CHARACTER(LEN=*), PARAMETER :: TSSSPRK104 = 'rk104'

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::TSSSPRKS2
!DEC$ ATTRIBUTES DLLEXPORT::TSSSPRKS3
!DEC$ ATTRIBUTES DLLEXPORT::TSSSPRK104
#endif

  CHARACTER(LEN=*), PARAMETER :: TSADAPTNONE = 'none'
  CHARACTER(LEN=*), PARAMETER :: TSADAPTBASIC = 'basic'
  CHARACTER(LEN=*), PARAMETER :: TSADAPTDSP = 'dsp'
  CHARACTER(LEN=*), PARAMETER :: TSADAPTCFL = 'cfl'
  CHARACTER(LEN=*), PARAMETER :: TSADAPTGLEE = 'glee'
  CHARACTER(LEN=*), PARAMETER :: TSADAPTHISTORY = 'history'

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::TSADAPTNONE
!DEC$ ATTRIBUTES DLLEXPORT::TSADAPTBASIC
!DEC$ ATTRIBUTES DLLEXPORT::TSADAPTDSP
!DEC$ ATTRIBUTES DLLEXPORT::TSADAPTCFL
!DEC$ ATTRIBUTES DLLEXPORT::TSADAPTGLEE
!DEC$ ATTRIBUTES DLLEXPORT::TSADAPTHISTORY
#endif

  CHARACTER(LEN=*), PARAMETER :: TSGLLEADAPT_NONE = 'none'
  CHARACTER(LEN=*), PARAMETER :: TSGLLEADAPT_SIZE = 'size'
  CHARACTER(LEN=*), PARAMETER :: TSGLLEADAPT_BOTH = 'both'

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::TSGLLEADAPT_NONE
!DEC$ ATTRIBUTES DLLEXPORT::TSGLLEADAPT_SIZE
!DEC$ ATTRIBUTES DLLEXPORT::TSGLLEADAPT_BOTH
#endif

  CHARACTER(LEN=*), PARAMETER :: TSGLLEACCEPT_ALWAYS = 'always'

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::TSGLLEACCEPT_ALWAYS
#endif

  CHARACTER(LEN=*), PARAMETER :: TSGLLE_IRKS = 'irks'

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::TSGLLE_IRKS
#endif

  CHARACTER(LEN=*), PARAMETER :: TSRK1FE = '1fe'
  CHARACTER(LEN=*), PARAMETER :: TSRK2A = '2a'
  CHARACTER(LEN=*), PARAMETER :: TSRK2B = '2b'
  CHARACTER(LEN=*), PARAMETER :: TSRK3 = '3'
  CHARACTER(LEN=*), PARAMETER :: TSRK3BS = '3bs'
  CHARACTER(LEN=*), PARAMETER :: TSRK4 = '4'
  CHARACTER(LEN=*), PARAMETER :: TSRK5F = '5f'
  CHARACTER(LEN=*), PARAMETER :: TSRK5DP = '5dp'
  CHARACTER(LEN=*), PARAMETER :: TSRK5BS = '5bs'
  CHARACTER(LEN=*), PARAMETER :: TSRK6VR = '6vr'
  CHARACTER(LEN=*), PARAMETER :: TSRK7VR = '7vr'
  CHARACTER(LEN=*), PARAMETER :: TSRK8VR = '8vr'

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::TSRK1FE
!DEC$ ATTRIBUTES DLLEXPORT::TSRK2A
!DEC$ ATTRIBUTES DLLEXPORT::TSRK2B
!DEC$ ATTRIBUTES DLLEXPORT::TSRK3
!DEC$ ATTRIBUTES DLLEXPORT::TSRK3BS
!DEC$ ATTRIBUTES DLLEXPORT::TSRK4
!DEC$ ATTRIBUTES DLLEXPORT::TSRK5F
!DEC$ ATTRIBUTES DLLEXPORT::TSRK5DP
!DEC$ ATTRIBUTES DLLEXPORT::TSRK5BS
!DEC$ ATTRIBUTES DLLEXPORT::TSRK6VR
!DEC$ ATTRIBUTES DLLEXPORT::TSRK7VR
!DEC$ ATTRIBUTES DLLEXPORT::TSRK8VR
#endif

  CHARACTER(LEN=*), PARAMETER :: TSMPRK2A22 = '2a22'
  CHARACTER(LEN=*), PARAMETER :: TSMPRK2A23 = '2a23'
  CHARACTER(LEN=*), PARAMETER :: TSMPRK2A32 = '2a32'
  CHARACTER(LEN=*), PARAMETER :: TSMPRK2A33 = '2a33'
  CHARACTER(LEN=*), PARAMETER :: TSMPRKP2 = 'p2'
  CHARACTER(LEN=*), PARAMETER :: TSMPRKP3 = 'p3'

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::TSMPRK2A22
!DEC$ ATTRIBUTES DLLEXPORT::TSMPRK2A23
!DEC$ ATTRIBUTES DLLEXPORT::TSMPRK2A32
!DEC$ ATTRIBUTES DLLEXPORT::TSMPRK2A33
!DEC$ ATTRIBUTES DLLEXPORT::TSMPRKP2
!DEC$ ATTRIBUTES DLLEXPORT::TSMPRKP3
#endif

  CHARACTER(LEN=*), PARAMETER :: TSIRKGAUSS = 'gauss'

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::TSIRKGAUSS
#endif

  CHARACTER(LEN=*), PARAMETER :: TSGLEEi1 = 'BE1'
  CHARACTER(LEN=*), PARAMETER :: TSGLEE23 = '23'
  CHARACTER(LEN=*), PARAMETER :: TSGLEE24 = '24'
  CHARACTER(LEN=*), PARAMETER :: TSGLEE25I = '25i'
  CHARACTER(LEN=*), PARAMETER :: TSGLEE35 = '35'
  CHARACTER(LEN=*), PARAMETER :: TSGLEEEXRK2A = 'exrk2a'
  CHARACTER(LEN=*), PARAMETER :: TSGLEERK32G1 = 'rk32g1'
  CHARACTER(LEN=*), PARAMETER :: TSGLEERK285EX = 'rk285ex'

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::TSGLEEi1
!DEC$ ATTRIBUTES DLLEXPORT::TSGLEE23
!DEC$ ATTRIBUTES DLLEXPORT::TSGLEE24
!DEC$ ATTRIBUTES DLLEXPORT::TSGLEE25I
!DEC$ ATTRIBUTES DLLEXPORT::TSGLEE35
!DEC$ ATTRIBUTES DLLEXPORT::TSGLEEEXRK2A
!DEC$ ATTRIBUTES DLLEXPORT::TSGLEERK32G1
!DEC$ ATTRIBUTES DLLEXPORT::TSGLEERK285EX
#endif

  CHARACTER(LEN=*), PARAMETER :: TSARKIMEX1BEE = '1bee'
  CHARACTER(LEN=*), PARAMETER :: TSARKIMEXA2 = 'a2'
  CHARACTER(LEN=*), PARAMETER :: TSARKIMEXL2 = 'l2'
  CHARACTER(LEN=*), PARAMETER :: TSARKIMEXARS122 = 'ars122'
  CHARACTER(LEN=*), PARAMETER :: TSARKIMEX2C = '2c'
  CHARACTER(LEN=*), PARAMETER :: TSARKIMEX2D = '2d'
  CHARACTER(LEN=*), PARAMETER :: TSARKIMEX2E = '2e'
  CHARACTER(LEN=*), PARAMETER :: TSARKIMEXPRSSP2 = 'prssp2'
  CHARACTER(LEN=*), PARAMETER :: TSARKIMEX3 = '3'
  CHARACTER(LEN=*), PARAMETER :: TSARKIMEXBPR3 = 'bpr3'
  CHARACTER(LEN=*), PARAMETER :: TSARKIMEXARS443 = 'ars443'
  CHARACTER(LEN=*), PARAMETER :: TSARKIMEX4 = '4'
  CHARACTER(LEN=*), PARAMETER :: TSARKIMEX5 = '5'

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::TSARKIMEX1BEE
!DEC$ ATTRIBUTES DLLEXPORT::TSARKIMEXA2
!DEC$ ATTRIBUTES DLLEXPORT::TSARKIMEXL2
!DEC$ ATTRIBUTES DLLEXPORT::TSARKIMEXARS122
!DEC$ ATTRIBUTES DLLEXPORT::TSARKIMEX2C
!DEC$ ATTRIBUTES DLLEXPORT::TSARKIMEX2D
!DEC$ ATTRIBUTES DLLEXPORT::TSARKIMEX2E
!DEC$ ATTRIBUTES DLLEXPORT::TSARKIMEXPRSSP2
!DEC$ ATTRIBUTES DLLEXPORT::TSARKIMEX3
!DEC$ ATTRIBUTES DLLEXPORT::TSARKIMEXBPR3
!DEC$ ATTRIBUTES DLLEXPORT::TSARKIMEXARS443
!DEC$ ATTRIBUTES DLLEXPORT::TSARKIMEX4
!DEC$ ATTRIBUTES DLLEXPORT::TSARKIMEX5
#endif

  CHARACTER(LEN=*), PARAMETER :: TSDIRKS212 = 's212'
  CHARACTER(LEN=*), PARAMETER :: TSDIRKES122SAL = 'es122sal'
  CHARACTER(LEN=*), PARAMETER :: TSDIRKES213SAL = 'es213sal'
  CHARACTER(LEN=*), PARAMETER :: TSDIRKES324SAL = 'es324sal'
  CHARACTER(LEN=*), PARAMETER :: TSDIRKES325SAL = 'es325sal'
  CHARACTER(LEN=*), PARAMETER :: TSDIRK657A = '657a'
  CHARACTER(LEN=*), PARAMETER :: TSDIRKES648SA = 'es648sa'
  CHARACTER(LEN=*), PARAMETER :: TSDIRK658A = '658a'
  CHARACTER(LEN=*), PARAMETER :: TSDIRKS659A = 's659a'
  CHARACTER(LEN=*), PARAMETER :: TSDIRK7510SAL = '7510sal'
  CHARACTER(LEN=*), PARAMETER :: TSDIRKES7510SA = 'es7510sa'
  CHARACTER(LEN=*), PARAMETER :: TSDIRK759A = '759a'
  CHARACTER(LEN=*), PARAMETER :: TSDIRKS7511SAL = 's7511sal'
  CHARACTER(LEN=*), PARAMETER :: TSDIRK8614A = '8614a'
  CHARACTER(LEN=*), PARAMETER :: TSDIRK8616SAL = '8616sal'
  CHARACTER(LEN=*), PARAMETER :: TSDIRKES8516SAL = 'es8516sal'

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::TSDIRKS212
!DEC$ ATTRIBUTES DLLEXPORT::TSDIRKES122SAL
!DEC$ ATTRIBUTES DLLEXPORT::TSDIRKES213SAL
!DEC$ ATTRIBUTES DLLEXPORT::TSDIRKES324SAL
!DEC$ ATTRIBUTES DLLEXPORT::TSDIRKES325SAL
!DEC$ ATTRIBUTES DLLEXPORT::TSDIRK657A
!DEC$ ATTRIBUTES DLLEXPORT::TSDIRKES648SA
!DEC$ ATTRIBUTES DLLEXPORT::TSDIRK658A
!DEC$ ATTRIBUTES DLLEXPORT::TSDIRKS659A
!DEC$ ATTRIBUTES DLLEXPORT::TSDIRK7510SAL
!DEC$ ATTRIBUTES DLLEXPORT::TSDIRKES7510SA
!DEC$ ATTRIBUTES DLLEXPORT::TSDIRK759A
!DEC$ ATTRIBUTES DLLEXPORT::TSDIRKS7511SAL
!DEC$ ATTRIBUTES DLLEXPORT::TSDIRK8614A
!DEC$ ATTRIBUTES DLLEXPORT::TSDIRK8616SAL
!DEC$ ATTRIBUTES DLLEXPORT::TSDIRKES8516SAL
#endif

  CHARACTER(LEN=*), PARAMETER :: TSROSW2M = '2m'
  CHARACTER(LEN=*), PARAMETER :: TSROSW2P = '2p'
  CHARACTER(LEN=*), PARAMETER :: TSROSWRA3PW = 'ra3pw'
  CHARACTER(LEN=*), PARAMETER :: TSROSWRA34PW2 = 'ra34pw2'
  CHARACTER(LEN=*), PARAMETER :: TSROSWR34PRW = 'r34prw'
  CHARACTER(LEN=*), PARAMETER :: TSROSWR3PRL2 = 'r3prl2'
  CHARACTER(LEN=*), PARAMETER :: TSROSWRODAS3 = 'rodas3'
  CHARACTER(LEN=*), PARAMETER :: TSROSWRODASPR = 'rodaspr'
  CHARACTER(LEN=*), PARAMETER :: TSROSWRODASPR2 = 'rodaspr2'
  CHARACTER(LEN=*), PARAMETER :: TSROSWSANDU3 = 'sandu3'
  CHARACTER(LEN=*), PARAMETER :: TSROSWASSP3P3S1C = 'assp3p3s1c'
  CHARACTER(LEN=*), PARAMETER :: TSROSWLASSP3P4S2C = 'lassp3p4s2c'
  CHARACTER(LEN=*), PARAMETER :: TSROSWLLSSP3P4S2C = 'llssp3p4s2c'
  CHARACTER(LEN=*), PARAMETER :: TSROSWARK3 = 'ark3'
  CHARACTER(LEN=*), PARAMETER :: TSROSWTHETA1 = 'theta1'
  CHARACTER(LEN=*), PARAMETER :: TSROSWTHETA2 = 'theta2'
  CHARACTER(LEN=*), PARAMETER :: TSROSWGRK4T = 'grk4t'
  CHARACTER(LEN=*), PARAMETER :: TSROSWSHAMP4 = 'shamp4'
  CHARACTER(LEN=*), PARAMETER :: TSROSWVELDD4 = 'veldd4'
  CHARACTER(LEN=*), PARAMETER :: TSROSW4L = '4l'

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::TSROSW2M
!DEC$ ATTRIBUTES DLLEXPORT::TSROSW2P
!DEC$ ATTRIBUTES DLLEXPORT::TSROSWRA3PW
!DEC$ ATTRIBUTES DLLEXPORT::TSROSWRA34PW2
!DEC$ ATTRIBUTES DLLEXPORT::TSROSWR34PRW
!DEC$ ATTRIBUTES DLLEXPORT::TSROSWR3PRL2
!DEC$ ATTRIBUTES DLLEXPORT::TSROSWRODAS3
!DEC$ ATTRIBUTES DLLEXPORT::TSROSWRODASPR
!DEC$ ATTRIBUTES DLLEXPORT::TSROSWRODASPR2
!DEC$ ATTRIBUTES DLLEXPORT::TSROSWSANDU3
!DEC$ ATTRIBUTES DLLEXPORT::TSROSWASSP3P3S1C
!DEC$ ATTRIBUTES DLLEXPORT::TSROSWLASSP3P4S2C
!DEC$ ATTRIBUTES DLLEXPORT::TSROSWLLSSP3P4S2C
!DEC$ ATTRIBUTES DLLEXPORT::TSROSWARK3
!DEC$ ATTRIBUTES DLLEXPORT::TSROSWTHETA1
!DEC$ ATTRIBUTES DLLEXPORT::TSROSWTHETA2
!DEC$ ATTRIBUTES DLLEXPORT::TSROSWGRK4T
!DEC$ ATTRIBUTES DLLEXPORT::TSROSWSHAMP4
!DEC$ ATTRIBUTES DLLEXPORT::TSROSWVELDD4
!DEC$ ATTRIBUTES DLLEXPORT::TSROSW4L
#endif

  CHARACTER(LEN=*), PARAMETER :: TSBASICSYMPLECTICSIEULER = '1'
  CHARACTER(LEN=*), PARAMETER :: TSBASICSYMPLECTICVELVERLET = '2'
  CHARACTER(LEN=*), PARAMETER :: TSBASICSYMPLECTIC3 = '3'
  CHARACTER(LEN=*), PARAMETER :: TSBASICSYMPLECTIC4 = '4'

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::TSBASICSYMPLECTICSIEULER
!DEC$ ATTRIBUTES DLLEXPORT::TSBASICSYMPLECTICVELVERLET
!DEC$ ATTRIBUTES DLLEXPORT::TSBASICSYMPLECTIC3
!DEC$ ATTRIBUTES DLLEXPORT::TSBASICSYMPLECTIC4
#endif

  type sTSMonitorDMDARayCtx
    Vec ray
    VecScatter scatter
    PetscViewer viewer
    TSMonitorLGCtx lgctx
  end type sTSMonitorDMDARayCtx

