#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsbasicsymplecticregisterall_ TSBASICSYMPLECTICREGISTERALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsbasicsymplecticregisterall_ tsbasicsymplecticregisterall
#endif
PETSC_EXTERN void tsbasicsymplecticregisterall_(PetscErrorCode *ierr)
{
  *ierr = TSBasicSymplecticRegisterAll();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsbasicsymplecticregisterdestroy_ TSBASICSYMPLECTICREGISTERDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsbasicsymplecticregisterdestroy_ tsbasicsymplecticregisterdestroy
#endif
PETSC_EXTERN void tsbasicsymplecticregisterdestroy_(PetscErrorCode *ierr)
{
  *ierr = TSBasicSymplecticRegisterDestroy();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsbasicsymplecticinitializepackage_ TSBASICSYMPLECTICINITIALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsbasicsymplecticinitializepackage_ tsbasicsymplecticinitializepackage
#endif
PETSC_EXTERN void tsbasicsymplecticinitializepackage_(PetscErrorCode *ierr)
{
  *ierr = TSBasicSymplecticInitializePackage();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsbasicsymplecticfinalizepackage_ TSBASICSYMPLECTICFINALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsbasicsymplecticfinalizepackage_ tsbasicsymplecticfinalizepackage
#endif
PETSC_EXTERN void tsbasicsymplecticfinalizepackage_(PetscErrorCode *ierr)
{
  *ierr = TSBasicSymplecticFinalizePackage();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsbasicsymplecticregister_ TSBASICSYMPLECTICREGISTER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsbasicsymplecticregister_ tsbasicsymplecticregister
#endif
PETSC_EXTERN void tsbasicsymplecticregister_(char *a, PetscInt *b, PetscInt *c, PetscReal d[], PetscReal e[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLREAL(e);
  *ierr = TSBasicSymplecticRegister(c_a, *b, *c, d, e);
  if (*ierr) return;
  FREECHAR(a, c_a);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsbasicsymplecticsettype_ TSBASICSYMPLECTICSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsbasicsymplecticsettype_ tsbasicsymplecticsettype
#endif
PETSC_EXTERN void tsbasicsymplecticsettype_(TS *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = TSBasicSymplecticSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsbasicsymplecticgettype_ TSBASICSYMPLECTICGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsbasicsymplecticgettype_ tsbasicsymplecticgettype
#endif
PETSC_EXTERN void tsbasicsymplecticgettype_(TS *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = TSBasicSymplecticGetType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
