#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscobjectgetoptions_ PETSCOBJECTGETOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscobjectgetoptions_ petscobjectgetoptions
#endif
PETSC_EXTERN void petscobjectgetoptions_(PetscObject *a, PetscOptions *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscObjectGetOptions(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscobjectsetoptions_ PETSCOBJECTSETOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscobjectsetoptions_ petscobjectsetoptions
#endif
PETSC_EXTERN void petscobjectsetoptions_(PetscObject *a, PetscOptions *b, PetscErrorCode *ierr)
{
  *ierr = PetscObjectSetOptions(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscobjectsetoptionsprefix_ PETSCOBJECTSETOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscobjectsetoptionsprefix_ petscobjectsetoptionsprefix
#endif
PETSC_EXTERN void petscobjectsetoptionsprefix_(PetscObject *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscObjectSetOptionsPrefix(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscobjectappendoptionsprefix_ PETSCOBJECTAPPENDOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscobjectappendoptionsprefix_ petscobjectappendoptionsprefix
#endif
PETSC_EXTERN void petscobjectappendoptionsprefix_(PetscObject *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscObjectAppendOptionsPrefix(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscobjectgetoptionsprefix_ PETSCOBJECTGETOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscobjectgetoptionsprefix_ petscobjectgetoptionsprefix
#endif
PETSC_EXTERN void petscobjectgetoptionsprefix_(PetscObject *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = PetscObjectGetOptionsPrefix(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscobjectprependoptionsprefix_ PETSCOBJECTPREPENDOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscobjectprependoptionsprefix_ petscobjectprependoptionsprefix
#endif
PETSC_EXTERN void petscobjectprependoptionsprefix_(PetscObject *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscObjectPrependOptionsPrefix(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
