#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscerror.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscpoperrorhandler_ PETSCPOPERRORHANDLER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscpoperrorhandler_ petscpoperrorhandler
#endif
PETSC_EXTERN void petscpoperrorhandler_(PetscErrorCode *ierr)
{
  *ierr = PetscPopErrorHandler();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscintviewnumcolumns_ PETSCINTVIEWNUMCOLUMNS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscintviewnumcolumns_ petscintviewnumcolumns
#endif
PETSC_EXTERN void petscintviewnumcolumns_(PetscInt *a, PetscInt *b, const PetscInt c[], PetscViewer *d, PetscErrorCode *ierr)
{
  PetscViewer v_d = PetscPatchDefaultViewers(d);
  CHKFORTRANNULLINTEGER(c);
  *ierr = PetscIntViewNumColumns(*a, *b, c, v_d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscrealviewnumcolumns_ PETSCREALVIEWNUMCOLUMNS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscrealviewnumcolumns_ petscrealviewnumcolumns
#endif
PETSC_EXTERN void petscrealviewnumcolumns_(PetscInt *a, PetscInt *b, const PetscReal c[], PetscViewer *d, PetscErrorCode *ierr)
{
  PetscViewer v_d = PetscPatchDefaultViewers(d);
  CHKFORTRANNULLREAL(c);
  *ierr = PetscRealViewNumColumns(*a, *b, c, v_d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscscalarviewnumcolumns_ PETSCSCALARVIEWNUMCOLUMNS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscscalarviewnumcolumns_ petscscalarviewnumcolumns
#endif
PETSC_EXTERN void petscscalarviewnumcolumns_(PetscInt *a, PetscInt *b, const PetscScalar c[], PetscViewer *d, PetscErrorCode *ierr)
{
  PetscViewer v_d = PetscPatchDefaultViewers(d);
  CHKFORTRANNULLSCALAR(c);
  *ierr = PetscScalarViewNumColumns(*a, *b, c, v_d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscintview_ PETSCINTVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscintview_ petscintview
#endif
PETSC_EXTERN void petscintview_(PetscInt *a, const PetscInt b[], PetscViewer *c, PetscErrorCode *ierr)
{
  PetscViewer v_c = PetscPatchDefaultViewers(c);
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscIntView(*a, b, v_c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscrealview_ PETSCREALVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscrealview_ petscrealview
#endif
PETSC_EXTERN void petscrealview_(PetscInt *a, const PetscReal b[], PetscViewer *c, PetscErrorCode *ierr)
{
  PetscViewer v_c = PetscPatchDefaultViewers(c);
  CHKFORTRANNULLREAL(b);
  *ierr = PetscRealView(*a, b, v_c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscscalarview_ PETSCSCALARVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscscalarview_ petscscalarview
#endif
PETSC_EXTERN void petscscalarview_(PetscInt *a, const PetscScalar b[], PetscViewer *c, PetscErrorCode *ierr)
{
  PetscViewer v_c = PetscPatchDefaultViewers(c);
  CHKFORTRANNULLSCALAR(b);
  *ierr = PetscScalarView(*a, b, v_c);
  if (*ierr) return;
}
