#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawfinalizepackage_ PETSCDRAWFINALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawfinalizepackage_ petscdrawfinalizepackage
#endif
PETSC_EXTERN void petscdrawfinalizepackage_(PetscErrorCode *ierr)
{
  *ierr = PetscDrawFinalizePackage();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawinitializepackage_ PETSCDRAWINITIALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawinitializepackage_ petscdrawinitializepackage
#endif
PETSC_EXTERN void petscdrawinitializepackage_(PetscErrorCode *ierr)
{
  *ierr = PetscDrawInitializePackage();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawresizewindow_ PETSCDRAWRESIZEWINDOW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawresizewindow_ petscdrawresizewindow
#endif
PETSC_EXTERN void petscdrawresizewindow_(PetscDraw *a, int *b, int *c, PetscErrorCode *ierr)
{
  *ierr = PetscDrawResizeWindow(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawgetwindowsize_ PETSCDRAWGETWINDOWSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawgetwindowsize_ petscdrawgetwindowsize
#endif
PETSC_EXTERN void petscdrawgetwindowsize_(PetscDraw *a, int *b, int *c, PetscErrorCode *ierr)
{
  *ierr = PetscDrawGetWindowSize(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawcheckresizedwindow_ PETSCDRAWCHECKRESIZEDWINDOW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawcheckresizedwindow_ petscdrawcheckresizedwindow
#endif
PETSC_EXTERN void petscdrawcheckresizedwindow_(PetscDraw *a, PetscErrorCode *ierr)
{
  *ierr = PetscDrawCheckResizedWindow(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawgettitle_ PETSCDRAWGETTITLE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawgettitle_ petscdrawgettitle
#endif
PETSC_EXTERN void petscdrawgettitle_(PetscDraw *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = PetscDrawGetTitle(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawsettitle_ PETSCDRAWSETTITLE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawsettitle_ petscdrawsettitle
#endif
PETSC_EXTERN void petscdrawsettitle_(PetscDraw *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscDrawSetTitle(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawappendtitle_ PETSCDRAWAPPENDTITLE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawappendtitle_ petscdrawappendtitle
#endif
PETSC_EXTERN void petscdrawappendtitle_(PetscDraw *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscDrawAppendTitle(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawdestroy_ PETSCDRAWDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawdestroy_ petscdrawdestroy
#endif
PETSC_EXTERN void petscdrawdestroy_(PetscDraw *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscDrawDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawgetpopup_ PETSCDRAWGETPOPUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawgetpopup_ petscdrawgetpopup
#endif
PETSC_EXTERN void petscdrawgetpopup_(PetscDraw *a, PetscDraw *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscDrawGetPopup(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawsetdisplay_ PETSCDRAWSETDISPLAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawsetdisplay_ petscdrawsetdisplay
#endif
PETSC_EXTERN void petscdrawsetdisplay_(PetscDraw *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscDrawSetDisplay(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawsetdoublebuffer_ PETSCDRAWSETDOUBLEBUFFER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawsetdoublebuffer_ petscdrawsetdoublebuffer
#endif
PETSC_EXTERN void petscdrawsetdoublebuffer_(PetscDraw *a, PetscErrorCode *ierr)
{
  *ierr = PetscDrawSetDoubleBuffer(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawgetsingleton_ PETSCDRAWGETSINGLETON
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawgetsingleton_ petscdrawgetsingleton
#endif
PETSC_EXTERN void petscdrawgetsingleton_(PetscDraw *a, PetscDraw *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscDrawGetSingleton(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawrestoresingleton_ PETSCDRAWRESTORESINGLETON
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawrestoresingleton_ petscdrawrestoresingleton
#endif
PETSC_EXTERN void petscdrawrestoresingleton_(PetscDraw *a, PetscDraw *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscDrawRestoreSingleton(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawsetvisible_ PETSCDRAWSETVISIBLE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawsetvisible_ petscdrawsetvisible
#endif
PETSC_EXTERN void petscdrawsetvisible_(PetscDraw *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PetscDrawSetVisible(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
