#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dminterpolationcreate_ DMINTERPOLATIONCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dminterpolationcreate_ dminterpolationcreate
#endif
PETSC_EXTERN void dminterpolationcreate_(MPI_Fint *a, DMInterpolationInfo *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMInterpolationCreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dminterpolationsetdim_ DMINTERPOLATIONSETDIM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dminterpolationsetdim_ dminterpolationsetdim
#endif
PETSC_EXTERN void dminterpolationsetdim_(DMInterpolationInfo *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = DMInterpolationSetDim(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dminterpolationgetdim_ DMINTERPOLATIONGETDIM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dminterpolationgetdim_ dminterpolationgetdim
#endif
PETSC_EXTERN void dminterpolationgetdim_(DMInterpolationInfo *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMInterpolationGetDim(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dminterpolationsetdof_ DMINTERPOLATIONSETDOF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dminterpolationsetdof_ dminterpolationsetdof
#endif
PETSC_EXTERN void dminterpolationsetdof_(DMInterpolationInfo *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = DMInterpolationSetDof(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dminterpolationgetdof_ DMINTERPOLATIONGETDOF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dminterpolationgetdof_ dminterpolationgetdof
#endif
PETSC_EXTERN void dminterpolationgetdof_(DMInterpolationInfo *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMInterpolationGetDof(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dminterpolationaddpoints_ DMINTERPOLATIONADDPOINTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dminterpolationaddpoints_ dminterpolationaddpoints
#endif
PETSC_EXTERN void dminterpolationaddpoints_(DMInterpolationInfo *a, PetscInt *b, PetscReal c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  *ierr = DMInterpolationAddPoints(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dminterpolationsetup_ DMINTERPOLATIONSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dminterpolationsetup_ dminterpolationsetup
#endif
PETSC_EXTERN void dminterpolationsetup_(DMInterpolationInfo *a, DM *b, PetscBool *c, PetscBool *d, PetscErrorCode *ierr)
{
  *ierr = DMInterpolationSetUp(*a, *b, *c ? PETSC_TRUE : PETSC_FALSE, *d ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dminterpolationgetcoordinates_ DMINTERPOLATIONGETCOORDINATES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dminterpolationgetcoordinates_ dminterpolationgetcoordinates
#endif
PETSC_EXTERN void dminterpolationgetcoordinates_(DMInterpolationInfo *a, Vec *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMInterpolationGetCoordinates(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dminterpolationgetvector_ DMINTERPOLATIONGETVECTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dminterpolationgetvector_ dminterpolationgetvector
#endif
PETSC_EXTERN void dminterpolationgetvector_(DMInterpolationInfo *a, Vec *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMInterpolationGetVector(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dminterpolationrestorevector_ DMINTERPOLATIONRESTOREVECTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dminterpolationrestorevector_ dminterpolationrestorevector
#endif
PETSC_EXTERN void dminterpolationrestorevector_(DMInterpolationInfo *a, Vec *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMInterpolationRestoreVector(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dminterpolationevaluate_ DMINTERPOLATIONEVALUATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dminterpolationevaluate_ dminterpolationevaluate
#endif
PETSC_EXTERN void dminterpolationevaluate_(DMInterpolationInfo *a, DM *b, Vec *c, Vec *d, PetscErrorCode *ierr)
{
  *ierr = DMInterpolationEvaluate(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dminterpolationdestroy_ DMINTERPOLATIONDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dminterpolationdestroy_ dminterpolationdestroy
#endif
PETSC_EXTERN void dminterpolationdestroy_(DMInterpolationInfo *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = DMInterpolationDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
