#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmpisellsetpreallocation_ MATMPISELLSETPREALLOCATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmpisellsetpreallocation_ matmpisellsetpreallocation
#endif
PETSC_EXTERN void matmpisellsetpreallocation_(Mat *a, PetscInt *b, const PetscInt c[], PetscInt *d, const PetscInt e[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(e);
  *ierr = MatMPISELLSetPreallocation(*a, *b, c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreatesell_ MATCREATESELL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreatesell_ matcreatesell
#endif
PETSC_EXTERN void matcreatesell_(MPI_Fint *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, PetscInt *f, const PetscInt g[], PetscInt *h, const PetscInt i[], Mat *j, PetscErrorCode *ierr)
{
  PetscBool null_j = !*(void**) j ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(g);
  CHKFORTRANNULLINTEGER(i);
  CHKFORTRANNULLOBJECT(j);
  *ierr = MatCreateSELL(MPI_Comm_f2c(*(a)), *b, *c, *d, *e, *f, g, *h, i, j);
  if (*ierr) return;
  if (! null_j && !*(void**) j) *(void **) j = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmpisellgetlocalmatcondensed_ MATMPISELLGETLOCALMATCONDENSED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmpisellgetlocalmatcondensed_ matmpisellgetlocalmatcondensed
#endif
PETSC_EXTERN void matmpisellgetlocalmatcondensed_(Mat *a, MatReuse *b, IS *c, IS *d, Mat *e, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  CHKFORTRANNULLOBJECT(d);
  CHKFORTRANNULLOBJECT(e);
  *ierr = MatMPISELLGetLocalMatCondensed(*a, *b, c, d, e);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
