#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matseqsbaijsetcolumnindices_ MATSEQSBAIJSETCOLUMNINDICES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matseqsbaijsetcolumnindices_ matseqsbaijsetcolumnindices
#endif
PETSC_EXTERN void matseqsbaijsetcolumnindices_(Mat *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = MatSeqSBAIJSetColumnIndices(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matseqsbaijsetpreallocation_ MATSEQSBAIJSETPREALLOCATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matseqsbaijsetpreallocation_ matseqsbaijsetpreallocation
#endif
PETSC_EXTERN void matseqsbaijsetpreallocation_(Mat *a, PetscInt *b, PetscInt *c, const PetscInt d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  *ierr = MatSeqSBAIJSetPreallocation(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matseqsbaijsetpreallocationcsr_ MATSEQSBAIJSETPREALLOCATIONCSR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matseqsbaijsetpreallocationcsr_ matseqsbaijsetpreallocationcsr
#endif
PETSC_EXTERN void matseqsbaijsetpreallocationcsr_(Mat *a, PetscInt *b, const PetscInt c[], const PetscInt d[], const PetscScalar e[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLSCALAR(e);
  *ierr = MatSeqSBAIJSetPreallocationCSR(*a, *b, c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreateseqsbaij_ MATCREATESEQSBAIJ
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreateseqsbaij_ matcreateseqsbaij
#endif
PETSC_EXTERN void matcreateseqsbaij_(MPI_Fint *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, const PetscInt f[], Mat *g, PetscErrorCode *ierr)
{
  PetscBool null_g = !*(void**) g ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(f);
  CHKFORTRANNULLOBJECT(g);
  *ierr = MatCreateSeqSBAIJ(MPI_Comm_f2c(*(a)), *b, *c, *d, *e, f, g);
  if (*ierr) return;
  if (! null_g && !*(void**) g) *(void **) g = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreateseqsbaijwitharrays_ MATCREATESEQSBAIJWITHARRAYS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreateseqsbaijwitharrays_ matcreateseqsbaijwitharrays
#endif
PETSC_EXTERN void matcreateseqsbaijwitharrays_(MPI_Fint *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt e[], PetscInt f[], PetscScalar g[], Mat *h, PetscErrorCode *ierr)
{
  PetscBool null_h = !*(void**) h ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLINTEGER(f);
  CHKFORTRANNULLSCALAR(g);
  CHKFORTRANNULLOBJECT(h);
  *ierr = MatCreateSeqSBAIJWithArrays(MPI_Comm_f2c(*(a)), *b, *c, *d, e, f, g, h);
  if (*ierr) return;
  if (! null_h && !*(void**) h) *(void **) h = (void *)-2;
}
