#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreatemffd_ MATCREATEMFFD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreatemffd_ matcreatemffd
#endif
PETSC_EXTERN void matcreatemffd_(MPI_Fint *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, Mat *f, PetscErrorCode *ierr)
{
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(f);
  *ierr = MatCreateMFFD(MPI_Comm_f2c(*(a)), *b, *c, *d, *e, f);
  if (*ierr) return;
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmffdfinalizepackage_ MATMFFDFINALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmffdfinalizepackage_ matmffdfinalizepackage
#endif
PETSC_EXTERN void matmffdfinalizepackage_(PetscErrorCode *ierr)
{
  *ierr = MatMFFDFinalizePackage();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmffdinitializepackage_ MATMFFDINITIALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmffdinitializepackage_ matmffdinitializepackage
#endif
PETSC_EXTERN void matmffdinitializepackage_(PetscErrorCode *ierr)
{
  *ierr = MatMFFDInitializePackage();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmffdsettype_ MATMFFDSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmffdsettype_ matmffdsettype
#endif
PETSC_EXTERN void matmffdsettype_(Mat *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = MatMFFDSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmffdsetoptionsprefix_ MATMFFDSETOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmffdsetoptionsprefix_ matmffdsetoptionsprefix
#endif
PETSC_EXTERN void matmffdsetoptionsprefix_(Mat *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = MatMFFDSetOptionsPrefix(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmffdgeth_ MATMFFDGETH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmffdgeth_ matmffdgeth
#endif
PETSC_EXTERN void matmffdgeth_(Mat *a, PetscScalar *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(b);
  *ierr = MatMFFDGetH(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmffdsetperiod_ MATMFFDSETPERIOD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmffdsetperiod_ matmffdsetperiod
#endif
PETSC_EXTERN void matmffdsetperiod_(Mat *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = MatMFFDSetPeriod(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmffdsetfunctionerror_ MATMFFDSETFUNCTIONERROR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmffdsetfunctionerror_ matmffdsetfunctionerror
#endif
PETSC_EXTERN void matmffdsetfunctionerror_(Mat *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = MatMFFDSetFunctionError(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmffdsethhistory_ MATMFFDSETHHISTORY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmffdsethhistory_ matmffdsethhistory
#endif
PETSC_EXTERN void matmffdsethhistory_(Mat *a, PetscScalar b[], PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(b);
  *ierr = MatMFFDSetHHistory(*a, b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmffdresethhistory_ MATMFFDRESETHHISTORY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmffdresethhistory_ matmffdresethhistory
#endif
PETSC_EXTERN void matmffdresethhistory_(Mat *a, PetscErrorCode *ierr)
{
  *ierr = MatMFFDResetHHistory(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmffdsetbase_ MATMFFDSETBASE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmffdsetbase_ matmffdsetbase
#endif
PETSC_EXTERN void matmffdsetbase_(Mat *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = MatMFFDSetBase(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmffdcheckpositivity_ MATMFFDCHECKPOSITIVITY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmffdcheckpositivity_ matmffdcheckpositivity
#endif
PETSC_EXTERN void matmffdcheckpositivity_(void *a, Vec *b, Vec *c, PetscScalar *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(d);
  *ierr = MatMFFDCheckPositivity(a, *b, *c, d);
  if (*ierr) return;
}
