#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matseqbaijsetcolumnindices_ MATSEQBAIJSETCOLUMNINDICES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matseqbaijsetcolumnindices_ matseqbaijsetcolumnindices
#endif
PETSC_EXTERN void matseqbaijsetcolumnindices_(Mat *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = MatSeqBAIJSetColumnIndices(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreateseqbaij_ MATCREATESEQBAIJ
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreateseqbaij_ matcreateseqbaij
#endif
PETSC_EXTERN void matcreateseqbaij_(MPI_Fint *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, const PetscInt f[], Mat *g, PetscErrorCode *ierr)
{
  PetscBool null_g = !*(void**) g ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(f);
  CHKFORTRANNULLOBJECT(g);
  *ierr = MatCreateSeqBAIJ(MPI_Comm_f2c(*(a)), *b, *c, *d, *e, f, g);
  if (*ierr) return;
  if (! null_g && !*(void**) g) *(void **) g = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matseqbaijsetpreallocation_ MATSEQBAIJSETPREALLOCATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matseqbaijsetpreallocation_ matseqbaijsetpreallocation
#endif
PETSC_EXTERN void matseqbaijsetpreallocation_(Mat *a, PetscInt *b, PetscInt *c, const PetscInt d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  *ierr = MatSeqBAIJSetPreallocation(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matseqbaijsetpreallocationcsr_ MATSEQBAIJSETPREALLOCATIONCSR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matseqbaijsetpreallocationcsr_ matseqbaijsetpreallocationcsr
#endif
PETSC_EXTERN void matseqbaijsetpreallocationcsr_(Mat *a, PetscInt *b, const PetscInt c[], const PetscInt d[], const PetscScalar e[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLSCALAR(e);
  *ierr = MatSeqBAIJSetPreallocationCSR(*a, *b, c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreateseqbaijwitharrays_ MATCREATESEQBAIJWITHARRAYS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreateseqbaijwitharrays_ matcreateseqbaijwitharrays
#endif
PETSC_EXTERN void matcreateseqbaijwitharrays_(MPI_Fint *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt e[], PetscInt f[], PetscScalar g[], Mat *h, PetscErrorCode *ierr)
{
  PetscBool null_h = !*(void**) h ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLINTEGER(f);
  CHKFORTRANNULLSCALAR(g);
  CHKFORTRANNULLOBJECT(h);
  *ierr = MatCreateSeqBAIJWithArrays(MPI_Comm_f2c(*(a)), *b, *c, *d, e, f, g, h);
  if (*ierr) return;
  if (! null_h && !*(void**) h) *(void **) h = (void *)-2;
}
