#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matinodeadjustforinodes_ MATINODEADJUSTFORINODES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matinodeadjustforinodes_ matinodeadjustforinodes
#endif
PETSC_EXTERN void matinodeadjustforinodes_(Mat *a, IS *b, IS *c, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = MatInodeAdjustForInodes(*a, b, c);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
