#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmpiaijgetnumbernonzeros_ MATMPIAIJGETNUMBERNONZEROS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmpiaijgetnumbernonzeros_ matmpiaijgetnumbernonzeros
#endif
PETSC_EXTERN void matmpiaijgetnumbernonzeros_(Mat *a, PetscCount *b, PetscErrorCode *ierr)
{
  *ierr = MatMPIAIJGetNumberNonzeros(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmpiaijsetusescalableincreaseoverlap_ MATMPIAIJSETUSESCALABLEINCREASEOVERLAP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmpiaijsetusescalableincreaseoverlap_ matmpiaijsetusescalableincreaseoverlap
#endif
PETSC_EXTERN void matmpiaijsetusescalableincreaseoverlap_(Mat *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = MatMPIAIJSetUseScalableIncreaseOverlap(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreatempiaijwithseqaij_ MATCREATEMPIAIJWITHSEQAIJ
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreatempiaijwithseqaij_ matcreatempiaijwithseqaij
#endif
PETSC_EXTERN void matcreatempiaijwithseqaij_(MPI_Fint *a, PetscInt *b, PetscInt *c, Mat *d, Mat *e, PetscInt *f, Mat *g, PetscErrorCode *ierr)
{
  PetscBool null_g = !*(void**) g ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(f);
  CHKFORTRANNULLOBJECT(g);
  *ierr = MatCreateMPIAIJWithSeqAIJ(MPI_Comm_f2c(*(a)), *b, *c, *d, *e, f, g);
  if (*ierr) return;
  if (! null_g && !*(void**) g) *(void **) g = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmpiaijsetpreallocationcsr_ MATMPIAIJSETPREALLOCATIONCSR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmpiaijsetpreallocationcsr_ matmpiaijsetpreallocationcsr
#endif
PETSC_EXTERN void matmpiaijsetpreallocationcsr_(Mat *a, const PetscInt b[], const PetscInt c[], const PetscScalar d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLSCALAR(d);
  *ierr = MatMPIAIJSetPreallocationCSR(*a, b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmpiaijsetpreallocation_ MATMPIAIJSETPREALLOCATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmpiaijsetpreallocation_ matmpiaijsetpreallocation
#endif
PETSC_EXTERN void matmpiaijsetpreallocation_(Mat *a, PetscInt *b, const PetscInt c[], PetscInt *d, const PetscInt e[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(e);
  *ierr = MatMPIAIJSetPreallocation(*a, *b, c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreatempiaijwitharrays_ MATCREATEMPIAIJWITHARRAYS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreatempiaijwitharrays_ matcreatempiaijwitharrays
#endif
PETSC_EXTERN void matcreatempiaijwitharrays_(MPI_Fint *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, const PetscInt f[], const PetscInt g[], const PetscScalar h[], Mat *i, PetscErrorCode *ierr)
{
  PetscBool null_i = !*(void**) i ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(f);
  CHKFORTRANNULLINTEGER(g);
  CHKFORTRANNULLSCALAR(h);
  CHKFORTRANNULLOBJECT(i);
  *ierr = MatCreateMPIAIJWithArrays(MPI_Comm_f2c(*(a)), *b, *c, *d, *e, f, g, h, i);
  if (*ierr) return;
  if (! null_i && !*(void**) i) *(void **) i = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matupdatempiaijwitharrays_ MATUPDATEMPIAIJWITHARRAYS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matupdatempiaijwitharrays_ matupdatempiaijwitharrays
#endif
PETSC_EXTERN void matupdatempiaijwitharrays_(Mat *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, const PetscInt f[], const PetscInt g[], const PetscScalar h[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(f);
  CHKFORTRANNULLINTEGER(g);
  CHKFORTRANNULLSCALAR(h);
  *ierr = MatUpdateMPIAIJWithArrays(*a, *b, *c, *d, *e, f, g, h);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matupdatempiaijwitharray_ MATUPDATEMPIAIJWITHARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matupdatempiaijwitharray_ matupdatempiaijwitharray
#endif
PETSC_EXTERN void matupdatempiaijwitharray_(Mat *a, const PetscScalar b[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(b);
  *ierr = MatUpdateMPIAIJWithArray(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreateaij_ MATCREATEAIJ
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreateaij_ matcreateaij
#endif
PETSC_EXTERN void matcreateaij_(MPI_Fint *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, PetscInt *f, const PetscInt g[], PetscInt *h, const PetscInt i[], Mat *j, PetscErrorCode *ierr)
{
  PetscBool null_j = !*(void**) j ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(g);
  CHKFORTRANNULLINTEGER(i);
  CHKFORTRANNULLOBJECT(j);
  *ierr = MatCreateAIJ(MPI_Comm_f2c(*(a)), *b, *c, *d, *e, *f, g, *h, i, j);
  if (*ierr) return;
  if (! null_j && !*(void**) j) *(void **) j = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreatempiaijsumseqaijnumeric_ MATCREATEMPIAIJSUMSEQAIJNUMERIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreatempiaijsumseqaijnumeric_ matcreatempiaijsumseqaijnumeric
#endif
PETSC_EXTERN void matcreatempiaijsumseqaijnumeric_(Mat *a, Mat *b, PetscErrorCode *ierr)
{
  *ierr = MatCreateMPIAIJSumSeqAIJNumeric(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreatempiaijsumseqaijsymbolic_ MATCREATEMPIAIJSUMSEQAIJSYMBOLIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreatempiaijsumseqaijsymbolic_ matcreatempiaijsumseqaijsymbolic
#endif
PETSC_EXTERN void matcreatempiaijsumseqaijsymbolic_(MPI_Fint *a, Mat *b, PetscInt *c, PetscInt *d, Mat *e, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(e);
  *ierr = MatCreateMPIAIJSumSeqAIJSymbolic(MPI_Comm_f2c(*(a)), *b, *c, *d, e);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreatempiaijsumseqaij_ MATCREATEMPIAIJSUMSEQAIJ
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreatempiaijsumseqaij_ matcreatempiaijsumseqaij
#endif
PETSC_EXTERN void matcreatempiaijsumseqaij_(MPI_Fint *a, Mat *b, PetscInt *c, PetscInt *d, MatReuse *e, Mat *f, PetscErrorCode *ierr)
{
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(f);
  *ierr = MatCreateMPIAIJSumSeqAIJ(MPI_Comm_f2c(*(a)), *b, *c, *d, *e, f);
  if (*ierr) return;
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define mataijgetlocalmat_ MATAIJGETLOCALMAT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define mataijgetlocalmat_ mataijgetlocalmat
#endif
PETSC_EXTERN void mataijgetlocalmat_(Mat *a, Mat *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatAIJGetLocalMat(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmpiaijgetlocalmat_ MATMPIAIJGETLOCALMAT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmpiaijgetlocalmat_ matmpiaijgetlocalmat
#endif
PETSC_EXTERN void matmpiaijgetlocalmat_(Mat *a, MatReuse *b, Mat *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = MatMPIAIJGetLocalMat(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmpiaijgetlocalmatmerge_ MATMPIAIJGETLOCALMATMERGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmpiaijgetlocalmatmerge_ matmpiaijgetlocalmatmerge
#endif
PETSC_EXTERN void matmpiaijgetlocalmatmerge_(Mat *a, MatReuse *b, IS *c, Mat *d, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  CHKFORTRANNULLOBJECT(d);
  *ierr = MatMPIAIJGetLocalMatMerge(*a, *b, c, d);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmpiaijgetlocalmatcondensed_ MATMPIAIJGETLOCALMATCONDENSED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmpiaijgetlocalmatcondensed_ matmpiaijgetlocalmatcondensed
#endif
PETSC_EXTERN void matmpiaijgetlocalmatcondensed_(Mat *a, MatReuse *b, IS *c, IS *d, Mat *e, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  CHKFORTRANNULLOBJECT(d);
  CHKFORTRANNULLOBJECT(e);
  *ierr = MatMPIAIJGetLocalMatCondensed(*a, *b, c, d, e);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetbrowsofacols_ MATGETBROWSOFACOLS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetbrowsofacols_ matgetbrowsofacols
#endif
PETSC_EXTERN void matgetbrowsofacols_(Mat *a, Mat *b, MatReuse *c, IS *d, IS *e, Mat *f, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  CHKFORTRANNULLOBJECT(e);
  CHKFORTRANNULLOBJECT(f);
  *ierr = MatGetBrowsOfAcols(*a, *b, *c, d, e, f);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreatempiaijwithsplitarrays_ MATCREATEMPIAIJWITHSPLITARRAYS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreatempiaijwithsplitarrays_ matcreatempiaijwithsplitarrays
#endif
PETSC_EXTERN void matcreatempiaijwithsplitarrays_(MPI_Fint *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, PetscInt f[], PetscInt g[], PetscScalar h[], PetscInt i[], PetscInt j[], PetscScalar k[], Mat *l, PetscErrorCode *ierr)
{
  PetscBool null_l = !*(void**) l ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(f);
  CHKFORTRANNULLINTEGER(g);
  CHKFORTRANNULLSCALAR(h);
  CHKFORTRANNULLINTEGER(i);
  CHKFORTRANNULLINTEGER(j);
  CHKFORTRANNULLSCALAR(k);
  CHKFORTRANNULLOBJECT(l);
  *ierr = MatCreateMPIAIJWithSplitArrays(MPI_Comm_f2c(*(a)), *b, *c, *d, *e, f, g, h, i, j, k, l);
  if (*ierr) return;
  if (! null_l && !*(void**) l) *(void **) l = (void *)-2;
}
