#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matpartitioninghierarchicalgetfineparts_ MATPARTITIONINGHIERARCHICALGETFINEPARTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matpartitioninghierarchicalgetfineparts_ matpartitioninghierarchicalgetfineparts
#endif
PETSC_EXTERN void matpartitioninghierarchicalgetfineparts_(MatPartitioning *a, IS *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatPartitioningHierarchicalGetFineparts(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matpartitioninghierarchicalgetcoarseparts_ MATPARTITIONINGHIERARCHICALGETCOARSEPARTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matpartitioninghierarchicalgetcoarseparts_ matpartitioninghierarchicalgetcoarseparts
#endif
PETSC_EXTERN void matpartitioninghierarchicalgetcoarseparts_(MatPartitioning *a, IS *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatPartitioningHierarchicalGetCoarseparts(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matpartitioninghierarchicalsetncoarseparts_ MATPARTITIONINGHIERARCHICALSETNCOARSEPARTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matpartitioninghierarchicalsetncoarseparts_ matpartitioninghierarchicalsetncoarseparts
#endif
PETSC_EXTERN void matpartitioninghierarchicalsetncoarseparts_(MatPartitioning *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = MatPartitioningHierarchicalSetNcoarseparts(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matpartitioninghierarchicalsetnfineparts_ MATPARTITIONINGHIERARCHICALSETNFINEPARTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matpartitioninghierarchicalsetnfineparts_ matpartitioninghierarchicalsetnfineparts
#endif
PETSC_EXTERN void matpartitioninghierarchicalsetnfineparts_(MatPartitioning *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = MatPartitioningHierarchicalSetNfineparts(*a, *b);
  if (*ierr) return;
}
