#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcoloringcreate_ MATCOLORINGCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcoloringcreate_ matcoloringcreate
#endif
PETSC_EXTERN void matcoloringcreate_(Mat *a, MatColoring *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatColoringCreate(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcoloringdestroy_ MATCOLORINGDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcoloringdestroy_ matcoloringdestroy
#endif
PETSC_EXTERN void matcoloringdestroy_(MatColoring *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = MatColoringDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcoloringsettype_ MATCOLORINGSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcoloringsettype_ matcoloringsettype
#endif
PETSC_EXTERN void matcoloringsettype_(MatColoring *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = MatColoringSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcoloringsetfromoptions_ MATCOLORINGSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcoloringsetfromoptions_ matcoloringsetfromoptions
#endif
PETSC_EXTERN void matcoloringsetfromoptions_(MatColoring *a, PetscErrorCode *ierr)
{
  *ierr = MatColoringSetFromOptions(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcoloringsetdistance_ MATCOLORINGSETDISTANCE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcoloringsetdistance_ matcoloringsetdistance
#endif
PETSC_EXTERN void matcoloringsetdistance_(MatColoring *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = MatColoringSetDistance(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcoloringgetdistance_ MATCOLORINGGETDISTANCE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcoloringgetdistance_ matcoloringgetdistance
#endif
PETSC_EXTERN void matcoloringgetdistance_(MatColoring *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = MatColoringGetDistance(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcoloringsetmaxcolors_ MATCOLORINGSETMAXCOLORS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcoloringsetmaxcolors_ matcoloringsetmaxcolors
#endif
PETSC_EXTERN void matcoloringsetmaxcolors_(MatColoring *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = MatColoringSetMaxColors(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcoloringgetmaxcolors_ MATCOLORINGGETMAXCOLORS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcoloringgetmaxcolors_ matcoloringgetmaxcolors
#endif
PETSC_EXTERN void matcoloringgetmaxcolors_(MatColoring *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = MatColoringGetMaxColors(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcoloringapply_ MATCOLORINGAPPLY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcoloringapply_ matcoloringapply
#endif
PETSC_EXTERN void matcoloringapply_(MatColoring *a, ISColoring *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatColoringApply(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcoloringview_ MATCOLORINGVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcoloringview_ matcoloringview
#endif
PETSC_EXTERN void matcoloringview_(MatColoring *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = MatColoringView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcoloringsetweighttype_ MATCOLORINGSETWEIGHTTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcoloringsetweighttype_ matcoloringsetweighttype
#endif
PETSC_EXTERN void matcoloringsetweighttype_(MatColoring *a, MatColoringWeightType *b, PetscErrorCode *ierr)
{
  *ierr = MatColoringSetWeightType(*a, *b);
  if (*ierr) return;
}
