#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pctelescopegetksp_ PCTELESCOPEGETKSP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pctelescopegetksp_ pctelescopegetksp
#endif
PETSC_EXTERN void pctelescopegetksp_(PC *a, KSP *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PCTelescopeGetKSP(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pctelescopegetreductionfactor_ PCTELESCOPEGETREDUCTIONFACTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pctelescopegetreductionfactor_ pctelescopegetreductionfactor
#endif
PETSC_EXTERN void pctelescopegetreductionfactor_(PC *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PCTelescopeGetReductionFactor(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pctelescopesetreductionfactor_ PCTELESCOPESETREDUCTIONFACTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pctelescopesetreductionfactor_ pctelescopesetreductionfactor
#endif
PETSC_EXTERN void pctelescopesetreductionfactor_(PC *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PCTelescopeSetReductionFactor(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pctelescopegetignoredm_ PCTELESCOPEGETIGNOREDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pctelescopegetignoredm_ pctelescopegetignoredm
#endif
PETSC_EXTERN void pctelescopegetignoredm_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PCTelescopeGetIgnoreDM(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pctelescopesetignoredm_ PCTELESCOPESETIGNOREDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pctelescopesetignoredm_ pctelescopesetignoredm
#endif
PETSC_EXTERN void pctelescopesetignoredm_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PCTelescopeSetIgnoreDM(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pctelescopegetusecoarsedm_ PCTELESCOPEGETUSECOARSEDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pctelescopegetusecoarsedm_ pctelescopegetusecoarsedm
#endif
PETSC_EXTERN void pctelescopegetusecoarsedm_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PCTelescopeGetUseCoarseDM(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pctelescopesetusecoarsedm_ PCTELESCOPESETUSECOARSEDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pctelescopesetusecoarsedm_ pctelescopesetusecoarsedm
#endif
PETSC_EXTERN void pctelescopesetusecoarsedm_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PCTelescopeSetUseCoarseDM(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pctelescopegetignorekspcomputeoperators_ PCTELESCOPEGETIGNOREKSPCOMPUTEOPERATORS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pctelescopegetignorekspcomputeoperators_ pctelescopegetignorekspcomputeoperators
#endif
PETSC_EXTERN void pctelescopegetignorekspcomputeoperators_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PCTelescopeGetIgnoreKSPComputeOperators(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pctelescopesetignorekspcomputeoperators_ PCTELESCOPESETIGNOREKSPCOMPUTEOPERATORS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pctelescopesetignorekspcomputeoperators_ pctelescopesetignorekspcomputeoperators
#endif
PETSC_EXTERN void pctelescopesetignorekspcomputeoperators_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PCTelescopeSetIgnoreKSPComputeOperators(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pctelescopegetdm_ PCTELESCOPEGETDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pctelescopegetdm_ pctelescopegetdm
#endif
PETSC_EXTERN void pctelescopegetdm_(PC *a, DM *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PCTelescopeGetDM(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pctelescopesetsubcommtype_ PCTELESCOPESETSUBCOMMTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pctelescopesetsubcommtype_ pctelescopesetsubcommtype
#endif
PETSC_EXTERN void pctelescopesetsubcommtype_(PC *a, PetscSubcommType *b, PetscErrorCode *ierr)
{
  *ierr = PCTelescopeSetSubcommType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pctelescopegetsubcommtype_ PCTELESCOPEGETSUBCOMMTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pctelescopegetsubcommtype_ pctelescopegetsubcommtype
#endif
PETSC_EXTERN void pctelescopegetsubcommtype_(PC *a, PetscSubcommType *b, PetscErrorCode *ierr)
{
  *ierr = PCTelescopeGetSubcommType(*a, b);
  if (*ierr) return;
}
