#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcpatchsetsaveoperators_ PCPATCHSETSAVEOPERATORS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcpatchsetsaveoperators_ pcpatchsetsaveoperators
#endif
PETSC_EXTERN void pcpatchsetsaveoperators_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PCPatchSetSaveOperators(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcpatchgetsaveoperators_ PCPATCHGETSAVEOPERATORS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcpatchgetsaveoperators_ pcpatchgetsaveoperators
#endif
PETSC_EXTERN void pcpatchgetsaveoperators_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PCPatchGetSaveOperators(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcpatchsetprecomputeelementtensors_ PCPATCHSETPRECOMPUTEELEMENTTENSORS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcpatchsetprecomputeelementtensors_ pcpatchsetprecomputeelementtensors
#endif
PETSC_EXTERN void pcpatchsetprecomputeelementtensors_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PCPatchSetPrecomputeElementTensors(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcpatchgetprecomputeelementtensors_ PCPATCHGETPRECOMPUTEELEMENTTENSORS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcpatchgetprecomputeelementtensors_ pcpatchgetprecomputeelementtensors
#endif
PETSC_EXTERN void pcpatchgetprecomputeelementtensors_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PCPatchGetPrecomputeElementTensors(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcpatchsetpartitionofunity_ PCPATCHSETPARTITIONOFUNITY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcpatchsetpartitionofunity_ pcpatchsetpartitionofunity
#endif
PETSC_EXTERN void pcpatchsetpartitionofunity_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PCPatchSetPartitionOfUnity(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcpatchgetpartitionofunity_ PCPATCHGETPARTITIONOFUNITY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcpatchgetpartitionofunity_ pcpatchgetpartitionofunity
#endif
PETSC_EXTERN void pcpatchgetpartitionofunity_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PCPatchGetPartitionOfUnity(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcpatchsetsubmattype_ PCPATCHSETSUBMATTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcpatchsetsubmattype_ pcpatchsetsubmattype
#endif
PETSC_EXTERN void pcpatchsetsubmattype_(PC *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PCPatchSetSubMatType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcpatchgetsubmattype_ PCPATCHGETSUBMATTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcpatchgetsubmattype_ pcpatchgetsubmattype
#endif
PETSC_EXTERN void pcpatchgetsubmattype_(PC *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = PCPatchGetSubMatType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcpatchsetcellnumbering_ PCPATCHSETCELLNUMBERING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcpatchsetcellnumbering_ pcpatchsetcellnumbering
#endif
PETSC_EXTERN void pcpatchsetcellnumbering_(PC *a, PetscSection *b, PetscErrorCode *ierr)
{
  *ierr = PCPatchSetCellNumbering(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcpatchgetcellnumbering_ PCPATCHGETCELLNUMBERING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcpatchgetcellnumbering_ pcpatchgetcellnumbering
#endif
PETSC_EXTERN void pcpatchgetcellnumbering_(PC *a, PetscSection *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PCPatchGetCellNumbering(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
