#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matlmvmsetmultalgorithm_ MATLMVMSETMULTALGORITHM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matlmvmsetmultalgorithm_ matlmvmsetmultalgorithm
#endif
PETSC_EXTERN void matlmvmsetmultalgorithm_(Mat *a, MatLMVMMultAlgorithm *b, PetscErrorCode *ierr)
{
  *ierr = MatLMVMSetMultAlgorithm(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matlmvmgetmultalgorithm_ MATLMVMGETMULTALGORITHM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matlmvmgetmultalgorithm_ matlmvmgetmultalgorithm
#endif
PETSC_EXTERN void matlmvmgetmultalgorithm_(Mat *a, MatLMVMMultAlgorithm *b, PetscErrorCode *ierr)
{
  *ierr = MatLMVMGetMultAlgorithm(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matlmvmgetlastupdate_ MATLMVMGETLASTUPDATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matlmvmgetlastupdate_ matlmvmgetlastupdate
#endif
PETSC_EXTERN void matlmvmgetlastupdate_(Mat *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = MatLMVMGetLastUpdate(*a, b, c);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
