#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdtfactorial_ PETSCDTFACTORIAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdtfactorial_ petscdtfactorial
#endif
PETSC_EXTERN void petscdtfactorial_(PetscInt *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = PetscDTFactorial(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdtfactorialint_ PETSCDTFACTORIALINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdtfactorialint_ petscdtfactorialint
#endif
PETSC_EXTERN void petscdtfactorialint_(PetscInt *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscDTFactorialInt(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdtbinomial_ PETSCDTBINOMIAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdtbinomial_ petscdtbinomial
#endif
PETSC_EXTERN void petscdtbinomial_(PetscInt *a, PetscInt *b, PetscReal *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  *ierr = PetscDTBinomial(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdtbinomialint_ PETSCDTBINOMIALINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdtbinomialint_ petscdtbinomialint
#endif
PETSC_EXTERN void petscdtbinomialint_(PetscInt *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = PetscDTBinomialInt(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdtenumperm_ PETSCDTENUMPERM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdtenumperm_ petscdtenumperm
#endif
PETSC_EXTERN void petscdtenumperm_(PetscInt *a, PetscInt *b, PetscInt *c, PetscBool *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLBOOL(d);
  *ierr = PetscDTEnumPerm(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdtpermindex_ PETSCDTPERMINDEX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdtpermindex_ petscdtpermindex
#endif
PETSC_EXTERN void petscdtpermindex_(PetscInt *a, const PetscInt *b, PetscInt *c, PetscBool *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLBOOL(d);
  *ierr = PetscDTPermIndex(*a, b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdtenumsubset_ PETSCDTENUMSUBSET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdtenumsubset_ petscdtenumsubset
#endif
PETSC_EXTERN void petscdtenumsubset_(PetscInt *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  *ierr = PetscDTEnumSubset(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdtsubsetindex_ PETSCDTSUBSETINDEX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdtsubsetindex_ petscdtsubsetindex
#endif
PETSC_EXTERN void petscdtsubsetindex_(PetscInt *a, PetscInt *b, const PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = PetscDTSubsetIndex(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdtenumsplit_ PETSCDTENUMSPLIT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdtenumsplit_ petscdtenumsplit
#endif
PETSC_EXTERN void petscdtenumsplit_(PetscInt *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscBool *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLBOOL(e);
  *ierr = PetscDTEnumSplit(*a, *b, *c, d, e);
  if (*ierr) return;
}
