#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabelephemeral.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelephemeralgettransform_ DMLABELEPHEMERALGETTRANSFORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelephemeralgettransform_ dmlabelephemeralgettransform
#endif
PETSC_EXTERN void dmlabelephemeralgettransform_(DMLabel *a, DMPlexTransform *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMLabelEphemeralGetTransform(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabelephemeral.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelephemeralsettransform_ DMLABELEPHEMERALSETTRANSFORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelephemeralsettransform_ dmlabelephemeralsettransform
#endif
PETSC_EXTERN void dmlabelephemeralsettransform_(DMLabel *a, DMPlexTransform *b, PetscErrorCode *ierr)
{
  *ierr = DMLabelEphemeralSetTransform(*a, *b);
  if (*ierr) return;
}
