#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgeommodelregisterall_ DMGEOMMODELREGISTERALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgeommodelregisterall_ dmgeommodelregisterall
#endif
PETSC_EXTERN void dmgeommodelregisterall_(PetscErrorCode *ierr)
{
  *ierr = DMGeomModelRegisterAll();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgeommodelregisterdestroy_ DMGEOMMODELREGISTERDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgeommodelregisterdestroy_ dmgeommodelregisterdestroy
#endif
PETSC_EXTERN void dmgeommodelregisterdestroy_(PetscErrorCode *ierr)
{
  *ierr = DMGeomModelRegisterDestroy();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetsnaptogeommodel_ DMSETSNAPTOGEOMMODEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetsnaptogeommodel_ dmsetsnaptogeommodel
#endif
PETSC_EXTERN void dmsetsnaptogeommodel_(DM *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = DMSetSnapToGeomModel(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsnaptogeommodel_ DMSNAPTOGEOMMODEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsnaptogeommodel_ dmsnaptogeommodel
#endif
PETSC_EXTERN void dmsnaptogeommodel_(DM *a, PetscInt *b, PetscInt *c, const PetscScalar d[], PetscScalar e[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(d);
  CHKFORTRANNULLSCALAR(e);
  *ierr = DMSnapToGeomModel(*a, *b, *c, d, e);
  if (*ierr) return;
}
