#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmviewfieldsxdmf_ DMSWARMVIEWFIELDSXDMF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmviewfieldsxdmf_ dmswarmviewfieldsxdmf
#endif
PETSC_EXTERN void dmswarmviewfieldsxdmf_(DM *a, char b[], PetscInt *c, char d[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_d)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_d = PETSC_NULLPTR;
  *ierr = DMSwarmViewFieldsXDMF(*a, c_b, *c, (const char **)&c_d);
  if (*ierr) return;
  FREECHAR(b, c_b);
  *ierr = PetscStrncpy((char *)d, c_d, l_d);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, d, l_d);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmviewxdmf_ DMSWARMVIEWXDMF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmviewxdmf_ dmswarmviewxdmf
#endif
PETSC_EXTERN void dmswarmviewxdmf_(DM *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = DMSwarmViewXDMF(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
