#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmsliced.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmslicedsetghosts_ DMSLICEDSETGHOSTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmslicedsetghosts_ dmslicedsetghosts
#endif
PETSC_EXTERN void dmslicedsetghosts_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, const PetscInt e[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(e);
  *ierr = DMSlicedSetGhosts(*a, *b, *c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmsliced.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmslicedsetpreallocation_ DMSLICEDSETPREALLOCATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmslicedsetpreallocation_ dmslicedsetpreallocation
#endif
PETSC_EXTERN void dmslicedsetpreallocation_(DM *a, PetscInt *b, const PetscInt c[], PetscInt *d, const PetscInt e[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(e);
  *ierr = DMSlicedSetPreallocation(*a, *b, c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmsliced.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmslicedsetblockfills_ DMSLICEDSETBLOCKFILLS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmslicedsetblockfills_ dmslicedsetblockfills
#endif
PETSC_EXTERN void dmslicedsetblockfills_(DM *a, const PetscInt b[], const PetscInt c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMSlicedSetBlockFills(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmsliced.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmslicedcreate_ DMSLICEDCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmslicedcreate_ dmslicedcreate
#endif
PETSC_EXTERN void dmslicedcreate_(MPI_Fint *a, PetscInt *b, PetscInt *c, PetscInt *d, const PetscInt e[], const PetscInt f[], const PetscInt g[], DM *h, PetscErrorCode *ierr)
{
  PetscBool null_h = !*(void**) h ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(h);
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLINTEGER(f);
  CHKFORTRANNULLINTEGER(g);
  CHKFORTRANNULLOBJECT(h);
  *ierr = DMSlicedCreate(MPI_Comm_f2c(*(a)), *b, *c, *d, e, f, g, h);
  if (*ierr) return;
  if (! null_h && !*(void**) h) *(void **) h = (void *)-2;
}
