#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmshell.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmglobaltolocalbegindefaultshell_ DMGLOBALTOLOCALBEGINDEFAULTSHELL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmglobaltolocalbegindefaultshell_ dmglobaltolocalbegindefaultshell
#endif
PETSC_EXTERN void dmglobaltolocalbegindefaultshell_(DM *a, Vec *b, InsertMode *c, Vec *d, PetscErrorCode *ierr)
{
  *ierr = DMGlobalToLocalBeginDefaultShell(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmshell.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmglobaltolocalenddefaultshell_ DMGLOBALTOLOCALENDDEFAULTSHELL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmglobaltolocalenddefaultshell_ dmglobaltolocalenddefaultshell
#endif
PETSC_EXTERN void dmglobaltolocalenddefaultshell_(DM *a, Vec *b, InsertMode *c, Vec *d, PetscErrorCode *ierr)
{
  *ierr = DMGlobalToLocalEndDefaultShell(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmshell.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlocaltoglobalbegindefaultshell_ DMLOCALTOGLOBALBEGINDEFAULTSHELL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlocaltoglobalbegindefaultshell_ dmlocaltoglobalbegindefaultshell
#endif
PETSC_EXTERN void dmlocaltoglobalbegindefaultshell_(DM *a, Vec *b, InsertMode *c, Vec *d, PetscErrorCode *ierr)
{
  *ierr = DMLocalToGlobalBeginDefaultShell(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmshell.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlocaltoglobalenddefaultshell_ DMLOCALTOGLOBALENDDEFAULTSHELL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlocaltoglobalenddefaultshell_ dmlocaltoglobalenddefaultshell
#endif
PETSC_EXTERN void dmlocaltoglobalenddefaultshell_(DM *a, Vec *b, InsertMode *c, Vec *d, PetscErrorCode *ierr)
{
  *ierr = DMLocalToGlobalEndDefaultShell(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmshell.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlocaltolocalbegindefaultshell_ DMLOCALTOLOCALBEGINDEFAULTSHELL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlocaltolocalbegindefaultshell_ dmlocaltolocalbegindefaultshell
#endif
PETSC_EXTERN void dmlocaltolocalbegindefaultshell_(DM *a, Vec *b, InsertMode *c, Vec *d, PetscErrorCode *ierr)
{
  *ierr = DMLocalToLocalBeginDefaultShell(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmshell.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlocaltolocalenddefaultshell_ DMLOCALTOLOCALENDDEFAULTSHELL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlocaltolocalenddefaultshell_ dmlocaltolocalenddefaultshell
#endif
PETSC_EXTERN void dmlocaltolocalenddefaultshell_(DM *a, Vec *b, InsertMode *c, Vec *d, PetscErrorCode *ierr)
{
  *ierr = DMLocalToLocalEndDefaultShell(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmshell.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmshellsetcontext_ DMSHELLSETCONTEXT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmshellsetcontext_ dmshellsetcontext
#endif
PETSC_EXTERN void dmshellsetcontext_(DM *a, void *b, PetscErrorCode *ierr)
{
  *ierr = DMShellSetContext(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmshell.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmshellgetcontext_ DMSHELLGETCONTEXT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmshellgetcontext_ dmshellgetcontext
#endif
PETSC_EXTERN void dmshellgetcontext_(DM *a, void *b, PetscErrorCode *ierr)
{
  *ierr = DMShellGetContext(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmshell.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmshellsetmatrix_ DMSHELLSETMATRIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmshellsetmatrix_ dmshellsetmatrix
#endif
PETSC_EXTERN void dmshellsetmatrix_(DM *a, Mat *b, PetscErrorCode *ierr)
{
  *ierr = DMShellSetMatrix(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmshell.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmshellsetglobalvector_ DMSHELLSETGLOBALVECTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmshellsetglobalvector_ dmshellsetglobalvector
#endif
PETSC_EXTERN void dmshellsetglobalvector_(DM *a, Vec *b, PetscErrorCode *ierr)
{
  *ierr = DMShellSetGlobalVector(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmshell.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmshellgetglobalvector_ DMSHELLGETGLOBALVECTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmshellgetglobalvector_ dmshellgetglobalvector
#endif
PETSC_EXTERN void dmshellgetglobalvector_(DM *a, Vec *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMShellGetGlobalVector(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmshell.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmshellsetlocalvector_ DMSHELLSETLOCALVECTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmshellsetlocalvector_ dmshellsetlocalvector
#endif
PETSC_EXTERN void dmshellsetlocalvector_(DM *a, Vec *b, PetscErrorCode *ierr)
{
  *ierr = DMShellSetLocalVector(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmshell.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmshellsetglobaltolocalvecscatter_ DMSHELLSETGLOBALTOLOCALVECSCATTER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmshellsetglobaltolocalvecscatter_ dmshellsetglobaltolocalvecscatter
#endif
PETSC_EXTERN void dmshellsetglobaltolocalvecscatter_(DM *a, VecScatter *b, PetscErrorCode *ierr)
{
  *ierr = DMShellSetGlobalToLocalVecScatter(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmshell.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmshellsetlocaltoglobalvecscatter_ DMSHELLSETLOCALTOGLOBALVECSCATTER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmshellsetlocaltoglobalvecscatter_ dmshellsetlocaltoglobalvecscatter
#endif
PETSC_EXTERN void dmshellsetlocaltoglobalvecscatter_(DM *a, VecScatter *b, PetscErrorCode *ierr)
{
  *ierr = DMShellSetLocalToGlobalVecScatter(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmshell.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmshellsetlocaltolocalvecscatter_ DMSHELLSETLOCALTOLOCALVECSCATTER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmshellsetlocaltolocalvecscatter_ dmshellsetlocaltolocalvecscatter
#endif
PETSC_EXTERN void dmshellsetlocaltolocalvecscatter_(DM *a, VecScatter *b, PetscErrorCode *ierr)
{
  *ierr = DMShellSetLocalToLocalVecScatter(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmshell.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmshellcreate_ DMSHELLCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmshellcreate_ dmshellcreate
#endif
PETSC_EXTERN void dmshellcreate_(MPI_Fint *a, DM *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMShellCreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
