#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetricsetfromoptions_ DMPLEXMETRICSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetricsetfromoptions_ dmplexmetricsetfromoptions
#endif
PETSC_EXTERN void dmplexmetricsetfromoptions_(DM *a, PetscErrorCode *ierr)
{
  *ierr = DMPlexMetricSetFromOptions(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetricsetisotropic_ DMPLEXMETRICSETISOTROPIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetricsetisotropic_ dmplexmetricsetisotropic
#endif
PETSC_EXTERN void dmplexmetricsetisotropic_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexMetricSetIsotropic(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetricisisotropic_ DMPLEXMETRICISISOTROPIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetricisisotropic_ dmplexmetricisisotropic
#endif
PETSC_EXTERN void dmplexmetricisisotropic_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = DMPlexMetricIsIsotropic(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetricsetuniform_ DMPLEXMETRICSETUNIFORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetricsetuniform_ dmplexmetricsetuniform
#endif
PETSC_EXTERN void dmplexmetricsetuniform_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexMetricSetUniform(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetricisuniform_ DMPLEXMETRICISUNIFORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetricisuniform_ dmplexmetricisuniform
#endif
PETSC_EXTERN void dmplexmetricisuniform_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = DMPlexMetricIsUniform(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetricsetrestrictanisotropyfirst_ DMPLEXMETRICSETRESTRICTANISOTROPYFIRST
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetricsetrestrictanisotropyfirst_ dmplexmetricsetrestrictanisotropyfirst
#endif
PETSC_EXTERN void dmplexmetricsetrestrictanisotropyfirst_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexMetricSetRestrictAnisotropyFirst(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetricrestrictanisotropyfirst_ DMPLEXMETRICRESTRICTANISOTROPYFIRST
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetricrestrictanisotropyfirst_ dmplexmetricrestrictanisotropyfirst
#endif
PETSC_EXTERN void dmplexmetricrestrictanisotropyfirst_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = DMPlexMetricRestrictAnisotropyFirst(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetricsetnoinsertion_ DMPLEXMETRICSETNOINSERTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetricsetnoinsertion_ dmplexmetricsetnoinsertion
#endif
PETSC_EXTERN void dmplexmetricsetnoinsertion_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexMetricSetNoInsertion(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetricnoinsertion_ DMPLEXMETRICNOINSERTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetricnoinsertion_ dmplexmetricnoinsertion
#endif
PETSC_EXTERN void dmplexmetricnoinsertion_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = DMPlexMetricNoInsertion(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetricsetnoswapping_ DMPLEXMETRICSETNOSWAPPING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetricsetnoswapping_ dmplexmetricsetnoswapping
#endif
PETSC_EXTERN void dmplexmetricsetnoswapping_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexMetricSetNoSwapping(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetricnoswapping_ DMPLEXMETRICNOSWAPPING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetricnoswapping_ dmplexmetricnoswapping
#endif
PETSC_EXTERN void dmplexmetricnoswapping_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = DMPlexMetricNoSwapping(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetricsetnomovement_ DMPLEXMETRICSETNOMOVEMENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetricsetnomovement_ dmplexmetricsetnomovement
#endif
PETSC_EXTERN void dmplexmetricsetnomovement_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexMetricSetNoMovement(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetricnomovement_ DMPLEXMETRICNOMOVEMENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetricnomovement_ dmplexmetricnomovement
#endif
PETSC_EXTERN void dmplexmetricnomovement_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = DMPlexMetricNoMovement(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetricsetnosurf_ DMPLEXMETRICSETNOSURF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetricsetnosurf_ dmplexmetricsetnosurf
#endif
PETSC_EXTERN void dmplexmetricsetnosurf_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexMetricSetNoSurf(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetricnosurf_ DMPLEXMETRICNOSURF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetricnosurf_ dmplexmetricnosurf
#endif
PETSC_EXTERN void dmplexmetricnosurf_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = DMPlexMetricNoSurf(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetricsetminimummagnitude_ DMPLEXMETRICSETMINIMUMMAGNITUDE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetricsetminimummagnitude_ dmplexmetricsetminimummagnitude
#endif
PETSC_EXTERN void dmplexmetricsetminimummagnitude_(DM *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexMetricSetMinimumMagnitude(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetricgetminimummagnitude_ DMPLEXMETRICGETMINIMUMMAGNITUDE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetricgetminimummagnitude_ dmplexmetricgetminimummagnitude
#endif
PETSC_EXTERN void dmplexmetricgetminimummagnitude_(DM *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = DMPlexMetricGetMinimumMagnitude(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetricsetmaximummagnitude_ DMPLEXMETRICSETMAXIMUMMAGNITUDE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetricsetmaximummagnitude_ dmplexmetricsetmaximummagnitude
#endif
PETSC_EXTERN void dmplexmetricsetmaximummagnitude_(DM *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexMetricSetMaximumMagnitude(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetricgetmaximummagnitude_ DMPLEXMETRICGETMAXIMUMMAGNITUDE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetricgetmaximummagnitude_ dmplexmetricgetmaximummagnitude
#endif
PETSC_EXTERN void dmplexmetricgetmaximummagnitude_(DM *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = DMPlexMetricGetMaximumMagnitude(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetricsetmaximumanisotropy_ DMPLEXMETRICSETMAXIMUMANISOTROPY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetricsetmaximumanisotropy_ dmplexmetricsetmaximumanisotropy
#endif
PETSC_EXTERN void dmplexmetricsetmaximumanisotropy_(DM *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexMetricSetMaximumAnisotropy(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetricgetmaximumanisotropy_ DMPLEXMETRICGETMAXIMUMANISOTROPY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetricgetmaximumanisotropy_ dmplexmetricgetmaximumanisotropy
#endif
PETSC_EXTERN void dmplexmetricgetmaximumanisotropy_(DM *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = DMPlexMetricGetMaximumAnisotropy(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetricsettargetcomplexity_ DMPLEXMETRICSETTARGETCOMPLEXITY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetricsettargetcomplexity_ dmplexmetricsettargetcomplexity
#endif
PETSC_EXTERN void dmplexmetricsettargetcomplexity_(DM *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexMetricSetTargetComplexity(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetricgettargetcomplexity_ DMPLEXMETRICGETTARGETCOMPLEXITY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetricgettargetcomplexity_ dmplexmetricgettargetcomplexity
#endif
PETSC_EXTERN void dmplexmetricgettargetcomplexity_(DM *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = DMPlexMetricGetTargetComplexity(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetricsetnormalizationorder_ DMPLEXMETRICSETNORMALIZATIONORDER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetricsetnormalizationorder_ dmplexmetricsetnormalizationorder
#endif
PETSC_EXTERN void dmplexmetricsetnormalizationorder_(DM *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexMetricSetNormalizationOrder(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetricgetnormalizationorder_ DMPLEXMETRICGETNORMALIZATIONORDER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetricgetnormalizationorder_ dmplexmetricgetnormalizationorder
#endif
PETSC_EXTERN void dmplexmetricgetnormalizationorder_(DM *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = DMPlexMetricGetNormalizationOrder(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetricsetgradationfactor_ DMPLEXMETRICSETGRADATIONFACTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetricsetgradationfactor_ dmplexmetricsetgradationfactor
#endif
PETSC_EXTERN void dmplexmetricsetgradationfactor_(DM *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexMetricSetGradationFactor(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetricgetgradationfactor_ DMPLEXMETRICGETGRADATIONFACTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetricgetgradationfactor_ dmplexmetricgetgradationfactor
#endif
PETSC_EXTERN void dmplexmetricgetgradationfactor_(DM *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = DMPlexMetricGetGradationFactor(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetricsethausdorffnumber_ DMPLEXMETRICSETHAUSDORFFNUMBER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetricsethausdorffnumber_ dmplexmetricsethausdorffnumber
#endif
PETSC_EXTERN void dmplexmetricsethausdorffnumber_(DM *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexMetricSetHausdorffNumber(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetricgethausdorffnumber_ DMPLEXMETRICGETHAUSDORFFNUMBER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetricgethausdorffnumber_ dmplexmetricgethausdorffnumber
#endif
PETSC_EXTERN void dmplexmetricgethausdorffnumber_(DM *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = DMPlexMetricGetHausdorffNumber(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetricsetverbosity_ DMPLEXMETRICSETVERBOSITY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetricsetverbosity_ dmplexmetricsetverbosity
#endif
PETSC_EXTERN void dmplexmetricsetverbosity_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexMetricSetVerbosity(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetricgetverbosity_ DMPLEXMETRICGETVERBOSITY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetricgetverbosity_ dmplexmetricgetverbosity
#endif
PETSC_EXTERN void dmplexmetricgetverbosity_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMPlexMetricGetVerbosity(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetricsetnumiterations_ DMPLEXMETRICSETNUMITERATIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetricsetnumiterations_ dmplexmetricsetnumiterations
#endif
PETSC_EXTERN void dmplexmetricsetnumiterations_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexMetricSetNumIterations(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetricgetnumiterations_ DMPLEXMETRICGETNUMITERATIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetricgetnumiterations_ dmplexmetricgetnumiterations
#endif
PETSC_EXTERN void dmplexmetricgetnumiterations_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMPlexMetricGetNumIterations(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetriccreate_ DMPLEXMETRICCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetriccreate_ dmplexmetriccreate
#endif
PETSC_EXTERN void dmplexmetriccreate_(DM *a, PetscInt *b, Vec *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(c);
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMPlexMetricCreate(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetriccreateuniform_ DMPLEXMETRICCREATEUNIFORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetriccreateuniform_ dmplexmetriccreateuniform
#endif
PETSC_EXTERN void dmplexmetriccreateuniform_(DM *a, PetscInt *b, PetscReal *c, Vec *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMPlexMetricCreateUniform(*a, *b, *c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetriccreateisotropic_ DMPLEXMETRICCREATEISOTROPIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetriccreateisotropic_ dmplexmetriccreateisotropic
#endif
PETSC_EXTERN void dmplexmetriccreateisotropic_(DM *a, PetscInt *b, Vec *c, Vec *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMPlexMetricCreateIsotropic(*a, *b, *c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetricdeterminantcreate_ DMPLEXMETRICDETERMINANTCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetricdeterminantcreate_ dmplexmetricdeterminantcreate
#endif
PETSC_EXTERN void dmplexmetricdeterminantcreate_(DM *a, PetscInt *b, Vec *c, DM *d, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(d);
  CHKFORTRANNULLOBJECT(c);
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMPlexMetricDeterminantCreate(*a, *b, c, d);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetricenforcespd_ DMPLEXMETRICENFORCESPD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetricenforcespd_ dmplexmetricenforcespd
#endif
PETSC_EXTERN void dmplexmetricenforcespd_(DM *a, Vec *b, PetscBool *c, PetscBool *d, Vec *e, Vec *f, PetscErrorCode *ierr)
{
  *ierr = DMPlexMetricEnforceSPD(*a, *b, *c ? PETSC_TRUE : PETSC_FALSE, *d ? PETSC_TRUE : PETSC_FALSE, *e, *f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetricnormalize_ DMPLEXMETRICNORMALIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetricnormalize_ dmplexmetricnormalize
#endif
PETSC_EXTERN void dmplexmetricnormalize_(DM *a, Vec *b, PetscBool *c, PetscBool *d, Vec *e, Vec *f, PetscErrorCode *ierr)
{
  *ierr = DMPlexMetricNormalize(*a, *b, *c ? PETSC_TRUE : PETSC_FALSE, *d ? PETSC_TRUE : PETSC_FALSE, *e, *f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetricaverage_ DMPLEXMETRICAVERAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetricaverage_ dmplexmetricaverage
#endif
PETSC_EXTERN void dmplexmetricaverage_(DM *a, PetscInt *b, PetscReal c[], Vec d[], Vec *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMPlexMetricAverage(*a, *b, c, d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetricaverage2_ DMPLEXMETRICAVERAGE2
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetricaverage2_ dmplexmetricaverage2
#endif
PETSC_EXTERN void dmplexmetricaverage2_(DM *a, Vec *b, Vec *c, Vec *d, PetscErrorCode *ierr)
{
  *ierr = DMPlexMetricAverage2(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetricaverage3_ DMPLEXMETRICAVERAGE3
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetricaverage3_ dmplexmetricaverage3
#endif
PETSC_EXTERN void dmplexmetricaverage3_(DM *a, Vec *b, Vec *c, Vec *d, Vec *e, PetscErrorCode *ierr)
{
  *ierr = DMPlexMetricAverage3(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetricintersection_ DMPLEXMETRICINTERSECTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetricintersection_ dmplexmetricintersection
#endif
PETSC_EXTERN void dmplexmetricintersection_(DM *a, PetscInt *b, Vec c[], Vec *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMPlexMetricIntersection(*a, *b, c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetricintersection2_ DMPLEXMETRICINTERSECTION2
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetricintersection2_ dmplexmetricintersection2
#endif
PETSC_EXTERN void dmplexmetricintersection2_(DM *a, Vec *b, Vec *c, Vec *d, PetscErrorCode *ierr)
{
  *ierr = DMPlexMetricIntersection2(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmetricintersection3_ DMPLEXMETRICINTERSECTION3
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmetricintersection3_ dmplexmetricintersection3
#endif
PETSC_EXTERN void dmplexmetricintersection3_(DM *a, Vec *b, Vec *c, Vec *d, Vec *e, PetscErrorCode *ierr)
{
  *ierr = DMPlexMetricIntersection3(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
