#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexinterpolatepointsf_ DMPLEXINTERPOLATEPOINTSF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexinterpolatepointsf_ dmplexinterpolatepointsf
#endif
PETSC_EXTERN void dmplexinterpolatepointsf_(DM *a, PetscSF *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexInterpolatePointSF(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexinterpolate_ DMPLEXINTERPOLATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexinterpolate_ dmplexinterpolate
#endif
PETSC_EXTERN void dmplexinterpolate_(DM *a, DM *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMPlexInterpolate(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcopycoordinates_ DMPLEXCOPYCOORDINATES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcopycoordinates_ dmplexcopycoordinates
#endif
PETSC_EXTERN void dmplexcopycoordinates_(DM *a, DM *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexCopyCoordinates(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexuninterpolate_ DMPLEXUNINTERPOLATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexuninterpolate_ dmplexuninterpolate
#endif
PETSC_EXTERN void dmplexuninterpolate_(DM *a, DM *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMPlexUninterpolate(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexisinterpolated_ DMPLEXISINTERPOLATED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexisinterpolated_ dmplexisinterpolated
#endif
PETSC_EXTERN void dmplexisinterpolated_(DM *a, DMPlexInterpolatedFlag *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexIsInterpolated(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexisinterpolatedcollective_ DMPLEXISINTERPOLATEDCOLLECTIVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexisinterpolatedcollective_ dmplexisinterpolatedcollective
#endif
PETSC_EXTERN void dmplexisinterpolatedcollective_(DM *a, DMPlexInterpolatedFlag *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexIsInterpolatedCollective(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetinterpolateprefertensor_ DMPLEXGETINTERPOLATEPREFERTENSOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetinterpolateprefertensor_ dmplexgetinterpolateprefertensor
#endif
PETSC_EXTERN void dmplexgetinterpolateprefertensor_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = DMPlexGetInterpolatePreferTensor(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsetinterpolateprefertensor_ DMPLEXSETINTERPOLATEPREFERTENSOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsetinterpolateprefertensor_ dmplexsetinterpolateprefertensor
#endif
PETSC_EXTERN void dmplexsetinterpolateprefertensor_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexSetInterpolatePreferTensor(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
