#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscgridhashcreate_ PETSCGRIDHASHCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscgridhashcreate_ petscgridhashcreate
#endif
PETSC_EXTERN void petscgridhashcreate_(MPI_Fint *a, PetscInt *b, const PetscScalar c[], PetscGridHash *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(d);
  CHKFORTRANNULLSCALAR(c);
  CHKFORTRANNULLOBJECT(d);
  *ierr = PetscGridHashCreate(MPI_Comm_f2c(*(a)), *b, c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscgridhashenlarge_ PETSCGRIDHASHENLARGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscgridhashenlarge_ petscgridhashenlarge
#endif
PETSC_EXTERN void petscgridhashenlarge_(PetscGridHash *a, const PetscScalar b[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(b);
  *ierr = PetscGridHashEnlarge(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscgridhashsetgrid_ PETSCGRIDHASHSETGRID
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscgridhashsetgrid_ petscgridhashsetgrid
#endif
PETSC_EXTERN void petscgridhashsetgrid_(PetscGridHash *a, const PetscInt b[], const PetscReal c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLREAL(c);
  *ierr = PetscGridHashSetGrid(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscgridhashgetenclosingbox_ PETSCGRIDHASHGETENCLOSINGBOX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscgridhashgetenclosingbox_ petscgridhashgetenclosingbox
#endif
PETSC_EXTERN void petscgridhashgetenclosingbox_(PetscGridHash *a, PetscInt *b, const PetscScalar c[], PetscInt d[], PetscInt e[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(c);
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLINTEGER(e);
  *ierr = PetscGridHashGetEnclosingBox(*a, *b, c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscgridhashdestroy_ PETSCGRIDHASHDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscgridhashdestroy_ petscgridhashdestroy
#endif
PETSC_EXTERN void petscgridhashdestroy_(PetscGridHash *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscGridHashDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexfindvertices_ DMPLEXFINDVERTICES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexfindvertices_ dmplexfindvertices
#endif
PETSC_EXTERN void dmplexfindvertices_(DM *a, Vec *b, PetscReal *c, IS *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMPlexFindVertices(*a, *b, *c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcomputeprojection2dto1d_ DMPLEXCOMPUTEPROJECTION2DTO1D
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcomputeprojection2dto1d_ dmplexcomputeprojection2dto1d
#endif
PETSC_EXTERN void dmplexcomputeprojection2dto1d_(PetscScalar a[], PetscReal b[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(a);
  CHKFORTRANNULLREAL(b);
  *ierr = DMPlexComputeProjection2Dto1D(a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcomputeprojection3dto1d_ DMPLEXCOMPUTEPROJECTION3DTO1D
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcomputeprojection3dto1d_ dmplexcomputeprojection3dto1d
#endif
PETSC_EXTERN void dmplexcomputeprojection3dto1d_(PetscScalar a[], PetscReal b[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(a);
  CHKFORTRANNULLREAL(b);
  *ierr = DMPlexComputeProjection3Dto1D(a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcomputeprojection3dto2d_ DMPLEXCOMPUTEPROJECTION3DTO2D
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcomputeprojection3dto2d_ dmplexcomputeprojection3dto2d
#endif
PETSC_EXTERN void dmplexcomputeprojection3dto2d_(PetscInt *a, PetscScalar b[], PetscReal c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(b);
  CHKFORTRANNULLREAL(c);
  *ierr = DMPlexComputeProjection3Dto2D(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcomputecellgeometryaffinefem_ DMPLEXCOMPUTECELLGEOMETRYAFFINEFEM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcomputecellgeometryaffinefem_ dmplexcomputecellgeometryaffinefem
#endif
PETSC_EXTERN void dmplexcomputecellgeometryaffinefem_(DM *a, PetscInt *b, PetscReal c[], PetscReal d[], PetscReal e[], PetscReal *f, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLREAL(e);
  CHKFORTRANNULLREAL(f);
  *ierr = DMPlexComputeCellGeometryAffineFEM(*a, *b, c, d, e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcomputecellgeometryfem_ DMPLEXCOMPUTECELLGEOMETRYFEM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcomputecellgeometryfem_ dmplexcomputecellgeometryfem
#endif
PETSC_EXTERN void dmplexcomputecellgeometryfem_(DM *a, PetscInt *b, PetscQuadrature *c, PetscReal d[], PetscReal e[], PetscReal f[], PetscReal g[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLREAL(e);
  CHKFORTRANNULLREAL(f);
  CHKFORTRANNULLREAL(g);
  *ierr = DMPlexComputeCellGeometryFEM(*a, *b, *c, d, e, f, g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcomputecellgeometryfvm_ DMPLEXCOMPUTECELLGEOMETRYFVM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcomputecellgeometryfvm_ dmplexcomputecellgeometryfvm
#endif
PETSC_EXTERN void dmplexcomputecellgeometryfvm_(DM *a, PetscInt *b, PetscReal *c, PetscReal d[], PetscReal e[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLREAL(e);
  *ierr = DMPlexComputeCellGeometryFVM(*a, *b, c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcomputegeometryfvm_ DMPLEXCOMPUTEGEOMETRYFVM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcomputegeometryfvm_ dmplexcomputegeometryfvm
#endif
PETSC_EXTERN void dmplexcomputegeometryfvm_(DM *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMPlexComputeGeometryFVM(*a, b, c);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetminradius_ DMPLEXGETMINRADIUS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetminradius_ dmplexgetminradius
#endif
PETSC_EXTERN void dmplexgetminradius_(DM *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = DMPlexGetMinRadius(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsetminradius_ DMPLEXSETMINRADIUS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsetminradius_ dmplexsetminradius
#endif
PETSC_EXTERN void dmplexsetminradius_(DM *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexSetMinRadius(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcomputegradientfvm_ DMPLEXCOMPUTEGRADIENTFVM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcomputegradientfvm_ dmplexcomputegradientfvm
#endif
PETSC_EXTERN void dmplexcomputegradientfvm_(DM *a, PetscFV *b, Vec *c, Vec *d, DM *e, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(e);
  *ierr = DMPlexComputeGradientFVM(*a, *b, *c, *d, e);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetdatafvm_ DMPLEXGETDATAFVM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetdatafvm_ dmplexgetdatafvm
#endif
PETSC_EXTERN void dmplexgetdatafvm_(DM *a, PetscFV *b, Vec *c, Vec *d, DM *e, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  CHKFORTRANNULLOBJECT(d);
  CHKFORTRANNULLOBJECT(e);
  *ierr = DMPlexGetDataFVM(*a, *b, c, d, e);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcoordinatestoreference_ DMPLEXCOORDINATESTOREFERENCE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcoordinatestoreference_ dmplexcoordinatestoreference
#endif
PETSC_EXTERN void dmplexcoordinatestoreference_(DM *a, PetscInt *b, PetscInt *c, const PetscReal d[], PetscReal e[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLREAL(e);
  *ierr = DMPlexCoordinatesToReference(*a, *b, *c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexreferencetocoordinates_ DMPLEXREFERENCETOCOORDINATES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexreferencetocoordinates_ dmplexreferencetocoordinates
#endif
PETSC_EXTERN void dmplexreferencetocoordinates_(DM *a, PetscInt *b, PetscInt *c, const PetscReal d[], PetscReal e[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLREAL(e);
  *ierr = DMPlexReferenceToCoordinates(*a, *b, *c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsheargeometry_ DMPLEXSHEARGEOMETRY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsheargeometry_ dmplexsheargeometry
#endif
PETSC_EXTERN void dmplexsheargeometry_(DM *a, DMDirection *b, PetscReal c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  *ierr = DMPlexShearGeometry(*a, *b, c);
  if (*ierr) return;
}
