#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmnetwork.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmnetworkmonitorcreate_ DMNETWORKMONITORCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmnetworkmonitorcreate_ dmnetworkmonitorcreate
#endif
PETSC_EXTERN void dmnetworkmonitorcreate_(DM *a, DMNetworkMonitor *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMNetworkMonitorCreate(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmnetwork.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmnetworkmonitordestroy_ DMNETWORKMONITORDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmnetworkmonitordestroy_ dmnetworkmonitordestroy
#endif
PETSC_EXTERN void dmnetworkmonitordestroy_(DMNetworkMonitor *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = DMNetworkMonitorDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmnetwork.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmnetworkmonitorpop_ DMNETWORKMONITORPOP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmnetworkmonitorpop_ dmnetworkmonitorpop
#endif
PETSC_EXTERN void dmnetworkmonitorpop_(DMNetworkMonitor *a, PetscErrorCode *ierr)
{
  *ierr = DMNetworkMonitorPop(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmnetwork.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmnetworkmonitoradd_ DMNETWORKMONITORADD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmnetworkmonitoradd_ dmnetworkmonitoradd
#endif
PETSC_EXTERN void dmnetworkmonitoradd_(DMNetworkMonitor *a, char b[], PetscInt *c, PetscInt *d, PetscInt *e, PetscInt *f, PetscReal *g, PetscReal *h, PetscReal *i, PetscReal *j, PetscBool *k, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = DMNetworkMonitorAdd(*a, c_b, *c, *d, *e, *f, *g, *h, *i, *j, *k ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmnetwork.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmnetworkmonitorview_ DMNETWORKMONITORVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmnetworkmonitorview_ dmnetworkmonitorview
#endif
PETSC_EXTERN void dmnetworkmonitorview_(DMNetworkMonitor *a, Vec *b, PetscErrorCode *ierr)
{
  *ierr = DMNetworkMonitorView(*a, *b);
  if (*ierr) return;
}
