#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdasetsizes_ DMDASETSIZES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdasetsizes_ dmdasetsizes
#endif
PETSC_EXTERN void dmdasetsizes_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  *ierr = DMDASetSizes(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdasetnumprocs_ DMDASETNUMPROCS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdasetnumprocs_ dmdasetnumprocs
#endif
PETSC_EXTERN void dmdasetnumprocs_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  *ierr = DMDASetNumProcs(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdagetboundarytype_ DMDAGETBOUNDARYTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdagetboundarytype_ dmdagetboundarytype
#endif
PETSC_EXTERN void dmdagetboundarytype_(DM *a, DMBoundaryType *b, DMBoundaryType *c, DMBoundaryType *d, PetscErrorCode *ierr)
{
  *ierr = DMDAGetBoundaryType(*a, b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdasetboundarytype_ DMDASETBOUNDARYTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdasetboundarytype_ dmdasetboundarytype
#endif
PETSC_EXTERN void dmdasetboundarytype_(DM *a, DMBoundaryType *b, DMBoundaryType *c, DMBoundaryType *d, PetscErrorCode *ierr)
{
  *ierr = DMDASetBoundaryType(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdasetdof_ DMDASETDOF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdasetdof_ dmdasetdof
#endif
PETSC_EXTERN void dmdasetdof_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = DMDASetDof(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdagetdof_ DMDAGETDOF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdagetdof_ dmdagetdof
#endif
PETSC_EXTERN void dmdagetdof_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMDAGetDof(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdagetoverlap_ DMDAGETOVERLAP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdagetoverlap_ dmdagetoverlap
#endif
PETSC_EXTERN void dmdagetoverlap_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMDAGetOverlap(*a, b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdasetoverlap_ DMDASETOVERLAP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdasetoverlap_ dmdasetoverlap
#endif
PETSC_EXTERN void dmdasetoverlap_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  *ierr = DMDASetOverlap(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdagetnumlocalsubdomains_ DMDAGETNUMLOCALSUBDOMAINS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdagetnumlocalsubdomains_ dmdagetnumlocalsubdomains
#endif
PETSC_EXTERN void dmdagetnumlocalsubdomains_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMDAGetNumLocalSubDomains(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdasetnumlocalsubdomains_ DMDASETNUMLOCALSUBDOMAINS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdasetnumlocalsubdomains_ dmdasetnumlocalsubdomains
#endif
PETSC_EXTERN void dmdasetnumlocalsubdomains_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = DMDASetNumLocalSubDomains(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdasetoffset_ DMDASETOFFSET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdasetoffset_ dmdasetoffset
#endif
PETSC_EXTERN void dmdasetoffset_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, PetscInt *f, PetscInt *g, PetscErrorCode *ierr)
{
  *ierr = DMDASetOffset(*a, *b, *c, *d, *e, *f, *g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdagetoffset_ DMDAGETOFFSET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdagetoffset_ dmdagetoffset
#endif
PETSC_EXTERN void dmdagetoffset_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, PetscInt *f, PetscInt *g, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLINTEGER(f);
  CHKFORTRANNULLINTEGER(g);
  *ierr = DMDAGetOffset(*a, b, c, d, e, f, g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdagetnonoverlappingregion_ DMDAGETNONOVERLAPPINGREGION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdagetnonoverlappingregion_ dmdagetnonoverlappingregion
#endif
PETSC_EXTERN void dmdagetnonoverlappingregion_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, PetscInt *f, PetscInt *g, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLINTEGER(f);
  CHKFORTRANNULLINTEGER(g);
  *ierr = DMDAGetNonOverlappingRegion(*a, b, c, d, e, f, g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdasetnonoverlappingregion_ DMDASETNONOVERLAPPINGREGION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdasetnonoverlappingregion_ dmdasetnonoverlappingregion
#endif
PETSC_EXTERN void dmdasetnonoverlappingregion_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, PetscInt *f, PetscInt *g, PetscErrorCode *ierr)
{
  *ierr = DMDASetNonOverlappingRegion(*a, *b, *c, *d, *e, *f, *g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdasetstenciltype_ DMDASETSTENCILTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdasetstenciltype_ dmdasetstenciltype
#endif
PETSC_EXTERN void dmdasetstenciltype_(DM *a, DMDAStencilType *b, PetscErrorCode *ierr)
{
  *ierr = DMDASetStencilType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdagetstenciltype_ DMDAGETSTENCILTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdagetstenciltype_ dmdagetstenciltype
#endif
PETSC_EXTERN void dmdagetstenciltype_(DM *a, DMDAStencilType *b, PetscErrorCode *ierr)
{
  *ierr = DMDAGetStencilType(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdasetstencilwidth_ DMDASETSTENCILWIDTH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdasetstencilwidth_ dmdasetstencilwidth
#endif
PETSC_EXTERN void dmdasetstencilwidth_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = DMDASetStencilWidth(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdagetstencilwidth_ DMDAGETSTENCILWIDTH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdagetstencilwidth_ dmdagetstencilwidth
#endif
PETSC_EXTERN void dmdagetstencilwidth_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMDAGetStencilWidth(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdasetownershipranges_ DMDASETOWNERSHIPRANGES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdasetownershipranges_ dmdasetownershipranges
#endif
PETSC_EXTERN void dmdasetownershipranges_(DM *a, const PetscInt b[], const PetscInt c[], const PetscInt d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMDASetOwnershipRanges(*a, b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdasetinterpolationtype_ DMDASETINTERPOLATIONTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdasetinterpolationtype_ dmdasetinterpolationtype
#endif
PETSC_EXTERN void dmdasetinterpolationtype_(DM *a, DMDAInterpolationType *b, PetscErrorCode *ierr)
{
  *ierr = DMDASetInterpolationType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdagetinterpolationtype_ DMDAGETINTERPOLATIONTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdagetinterpolationtype_ dmdagetinterpolationtype
#endif
PETSC_EXTERN void dmdagetinterpolationtype_(DM *a, DMDAInterpolationType *b, PetscErrorCode *ierr)
{
  *ierr = DMDAGetInterpolationType(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdasetrefinementfactor_ DMDASETREFINEMENTFACTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdasetrefinementfactor_ dmdasetrefinementfactor
#endif
PETSC_EXTERN void dmdasetrefinementfactor_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  *ierr = DMDASetRefinementFactor(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdagetrefinementfactor_ DMDAGETREFINEMENTFACTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdagetrefinementfactor_ dmdagetrefinementfactor
#endif
PETSC_EXTERN void dmdagetrefinementfactor_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMDAGetRefinementFactor(*a, b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdamapmatstenciltoglobal_ DMDAMAPMATSTENCILTOGLOBAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdamapmatstenciltoglobal_ dmdamapmatstenciltoglobal
#endif
PETSC_EXTERN void dmdamapmatstenciltoglobal_(DM *a, PetscInt *b, const MatStencil c[], PetscInt d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMDAMapMatStencilToGlobal(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdasetgllcoordinates_ DMDASETGLLCOORDINATES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdasetgllcoordinates_ dmdasetgllcoordinates
#endif
PETSC_EXTERN void dmdasetgllcoordinates_(DM *a, PetscInt *b, PetscReal *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  *ierr = DMDASetGLLCoordinates(*a, *b, c);
  if (*ierr) return;
}
