#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdacreate2d_ DMDACREATE2D
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdacreate2d_ dmdacreate2d
#endif
PETSC_EXTERN void dmdacreate2d_(MPI_Fint *a, DMBoundaryType *b, DMBoundaryType *c, DMDAStencilType *d, PetscInt *e, PetscInt *f, PetscInt *g, PetscInt *h, PetscInt *i, PetscInt *j, const PetscInt k[], const PetscInt l[], DM *m, PetscErrorCode *ierr)
{
  PetscBool null_m = !*(void**) m ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(k);
  CHKFORTRANNULLINTEGER(l);
  CHKFORTRANNULLOBJECT(m);
  *ierr = DMDACreate2d(MPI_Comm_f2c(*(a)), *b, *c, *d, *e, *f, *g, *h, *i, *j, k, l, m);
  if (*ierr) return;
  if (! null_m && !*(void**) m) *(void **) m = (void *)-2;
}
