#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecgettype_ VECGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecgettype_ vecgettype
#endif
PETSC_EXTERN void vecgettype_(Vec *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = VecGetType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecsettype_ VECSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecsettype_ vecsettype
#endif
PETSC_EXTERN void vecsettype_(Vec *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = VecSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
