#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadaptfinalizepackage_ TSADAPTFINALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadaptfinalizepackage_ tsadaptfinalizepackage
#endif
PETSC_EXTERN void tsadaptfinalizepackage_(PetscErrorCode *ierr)
{
  *ierr = TSAdaptFinalizePackage();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadaptinitializepackage_ TSADAPTINITIALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadaptinitializepackage_ tsadaptinitializepackage
#endif
PETSC_EXTERN void tsadaptinitializepackage_(PetscErrorCode *ierr)
{
  *ierr = TSAdaptInitializePackage();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadaptsettype_ TSADAPTSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadaptsettype_ tsadaptsettype
#endif
PETSC_EXTERN void tsadaptsettype_(TSAdapt *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = TSAdaptSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadaptgettype_ TSADAPTGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadaptgettype_ tsadaptgettype
#endif
PETSC_EXTERN void tsadaptgettype_(TSAdapt *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = TSAdaptGetType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadaptsetoptionsprefix_ TSADAPTSETOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadaptsetoptionsprefix_ tsadaptsetoptionsprefix
#endif
PETSC_EXTERN void tsadaptsetoptionsprefix_(TSAdapt *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = TSAdaptSetOptionsPrefix(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadaptload_ TSADAPTLOAD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadaptload_ tsadaptload
#endif
PETSC_EXTERN void tsadaptload_(TSAdapt *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = TSAdaptLoad(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadaptview_ TSADAPTVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadaptview_ tsadaptview
#endif
PETSC_EXTERN void tsadaptview_(TSAdapt *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = TSAdaptView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadaptreset_ TSADAPTRESET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadaptreset_ tsadaptreset
#endif
PETSC_EXTERN void tsadaptreset_(TSAdapt *a, PetscErrorCode *ierr)
{
  *ierr = TSAdaptReset(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadaptdestroy_ TSADAPTDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadaptdestroy_ tsadaptdestroy
#endif
PETSC_EXTERN void tsadaptdestroy_(TSAdapt *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = TSAdaptDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadaptsetmonitor_ TSADAPTSETMONITOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadaptsetmonitor_ tsadaptsetmonitor
#endif
PETSC_EXTERN void tsadaptsetmonitor_(TSAdapt *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = TSAdaptSetMonitor(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadaptsetalwaysaccept_ TSADAPTSETALWAYSACCEPT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadaptsetalwaysaccept_ tsadaptsetalwaysaccept
#endif
PETSC_EXTERN void tsadaptsetalwaysaccept_(TSAdapt *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = TSAdaptSetAlwaysAccept(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadaptsetsafety_ TSADAPTSETSAFETY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadaptsetsafety_ tsadaptsetsafety
#endif
PETSC_EXTERN void tsadaptsetsafety_(TSAdapt *a, PetscReal *b, PetscReal *c, PetscErrorCode *ierr)
{
  *ierr = TSAdaptSetSafety(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadaptgetsafety_ TSADAPTGETSAFETY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadaptgetsafety_ tsadaptgetsafety
#endif
PETSC_EXTERN void tsadaptgetsafety_(TSAdapt *a, PetscReal *b, PetscReal *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  *ierr = TSAdaptGetSafety(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadaptsetmaxignore_ TSADAPTSETMAXIGNORE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadaptsetmaxignore_ tsadaptsetmaxignore
#endif
PETSC_EXTERN void tsadaptsetmaxignore_(TSAdapt *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = TSAdaptSetMaxIgnore(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadaptgetmaxignore_ TSADAPTGETMAXIGNORE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadaptgetmaxignore_ tsadaptgetmaxignore
#endif
PETSC_EXTERN void tsadaptgetmaxignore_(TSAdapt *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = TSAdaptGetMaxIgnore(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadaptsetclip_ TSADAPTSETCLIP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadaptsetclip_ tsadaptsetclip
#endif
PETSC_EXTERN void tsadaptsetclip_(TSAdapt *a, PetscReal *b, PetscReal *c, PetscErrorCode *ierr)
{
  *ierr = TSAdaptSetClip(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadaptgetclip_ TSADAPTGETCLIP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadaptgetclip_ tsadaptgetclip
#endif
PETSC_EXTERN void tsadaptgetclip_(TSAdapt *a, PetscReal *b, PetscReal *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  *ierr = TSAdaptGetClip(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadaptsetscalesolvefailed_ TSADAPTSETSCALESOLVEFAILED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadaptsetscalesolvefailed_ tsadaptsetscalesolvefailed
#endif
PETSC_EXTERN void tsadaptsetscalesolvefailed_(TSAdapt *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = TSAdaptSetScaleSolveFailed(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadaptgetscalesolvefailed_ TSADAPTGETSCALESOLVEFAILED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadaptgetscalesolvefailed_ tsadaptgetscalesolvefailed
#endif
PETSC_EXTERN void tsadaptgetscalesolvefailed_(TSAdapt *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = TSAdaptGetScaleSolveFailed(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadaptsetsteplimits_ TSADAPTSETSTEPLIMITS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadaptsetsteplimits_ tsadaptsetsteplimits
#endif
PETSC_EXTERN void tsadaptsetsteplimits_(TSAdapt *a, PetscReal *b, PetscReal *c, PetscErrorCode *ierr)
{
  *ierr = TSAdaptSetStepLimits(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadaptgetsteplimits_ TSADAPTGETSTEPLIMITS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadaptgetsteplimits_ tsadaptgetsteplimits
#endif
PETSC_EXTERN void tsadaptgetsteplimits_(TSAdapt *a, PetscReal *b, PetscReal *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  *ierr = TSAdaptGetStepLimits(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadaptsetfromoptions_ TSADAPTSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadaptsetfromoptions_ tsadaptsetfromoptions
#endif
PETSC_EXTERN void tsadaptsetfromoptions_(TSAdapt *a, PetscOptionItems *b, PetscErrorCode *ierr)
{
  *ierr = TSAdaptSetFromOptions(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadaptcandidatesclear_ TSADAPTCANDIDATESCLEAR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadaptcandidatesclear_ tsadaptcandidatesclear
#endif
PETSC_EXTERN void tsadaptcandidatesclear_(TSAdapt *a, PetscErrorCode *ierr)
{
  *ierr = TSAdaptCandidatesClear(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadaptcandidateadd_ TSADAPTCANDIDATEADD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadaptcandidateadd_ tsadaptcandidateadd
#endif
PETSC_EXTERN void tsadaptcandidateadd_(TSAdapt *a, char b[], PetscInt *c, PetscInt *d, PetscReal *e, PetscReal *f, PetscBool *g, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = TSAdaptCandidateAdd(*a, c_b, *c, *d, *e, *f, *g ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadaptchoose_ TSADAPTCHOOSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadaptchoose_ tsadaptchoose
#endif
PETSC_EXTERN void tsadaptchoose_(TSAdapt *a, TS *b, PetscReal *c, PetscInt *d, PetscReal *e, PetscBool *f, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLREAL(e);
  CHKFORTRANNULLBOOL(f);
  *ierr = TSAdaptChoose(*a, *b, *c, d, e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadaptsettimestepincreasedelay_ TSADAPTSETTIMESTEPINCREASEDELAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadaptsettimestepincreasedelay_ tsadaptsettimestepincreasedelay
#endif
PETSC_EXTERN void tsadaptsettimestepincreasedelay_(TSAdapt *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = TSAdaptSetTimeStepIncreaseDelay(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadaptcheckstage_ TSADAPTCHECKSTAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadaptcheckstage_ tsadaptcheckstage
#endif
PETSC_EXTERN void tsadaptcheckstage_(TSAdapt *a, TS *b, PetscReal *c, Vec *d, PetscBool *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(e);
  *ierr = TSAdaptCheckStage(*a, *b, *c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadaptcreate_ TSADAPTCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadaptcreate_ tsadaptcreate
#endif
PETSC_EXTERN void tsadaptcreate_(MPI_Fint *a, TSAdapt *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = TSAdaptCreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
