#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscmath.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclinearregression_ PETSCLINEARREGRESSION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclinearregression_ petsclinearregression
#endif
PETSC_EXTERN void petsclinearregression_(PetscInt *a, const PetscReal b[], const PetscReal c[], PetscReal *d, PetscReal *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLREAL(e);
  *ierr = PetscLinearRegression(*a, b, c, d, e);
  if (*ierr) return;
}
