#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerdrawbaseadd_ PETSCVIEWERDRAWBASEADD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerdrawbaseadd_ petscviewerdrawbaseadd
#endif
PETSC_EXTERN void petscviewerdrawbaseadd_(PetscViewer *a, PetscInt *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerDrawBaseAdd(v_a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerdrawbaseset_ PETSCVIEWERDRAWBASESET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerdrawbaseset_ petscviewerdrawbaseset
#endif
PETSC_EXTERN void petscviewerdrawbaseset_(PetscViewer *a, PetscInt *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerDrawBaseSet(v_a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerdrawresize_ PETSCVIEWERDRAWRESIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerdrawresize_ petscviewerdrawresize
#endif
PETSC_EXTERN void petscviewerdrawresize_(PetscViewer *a, int *b, int *c, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerDrawResize(v_a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerdrawsetinfo_ PETSCVIEWERDRAWSETINFO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerdrawsetinfo_ petscviewerdrawsetinfo
#endif
PETSC_EXTERN void petscviewerdrawsetinfo_(PetscViewer *a, char b[], char c[], int *d, int *e, int *f, int *g, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerDrawSetInfo(v_a, c_b, c_c, *d, *e, *f, *g);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerdrawsettitle_ PETSCVIEWERDRAWSETTITLE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerdrawsettitle_ petscviewerdrawsettitle
#endif
PETSC_EXTERN void petscviewerdrawsettitle_(PetscViewer *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerDrawSetTitle(v_a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerdrawgettitle_ PETSCVIEWERDRAWGETTITLE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerdrawgettitle_ petscviewerdrawgettitle
#endif
PETSC_EXTERN void petscviewerdrawgettitle_(PetscViewer *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerDrawGetTitle(v_a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerdrawopen_ PETSCVIEWERDRAWOPEN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerdrawopen_ petscviewerdrawopen
#endif
PETSC_EXTERN void petscviewerdrawopen_(MPI_Fint *a, char b[], char c[], int *d, int *e, int *f, int *g, PetscViewer *h, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  PetscBool null_h = !*(void**) h ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  CHKFORTRANNULLOBJECT(h);
  *ierr = PetscViewerDrawOpen(MPI_Comm_f2c(*(a)), c_b, c_c, *d, *e, *f, *g, h);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FREECHAR(c, c_c);
  if (! null_h && !*(void**) h) *(void **) h = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerdrawclear_ PETSCVIEWERDRAWCLEAR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerdrawclear_ petscviewerdrawclear
#endif
PETSC_EXTERN void petscviewerdrawclear_(PetscViewer *a, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerDrawClear(v_a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerdrawgetpause_ PETSCVIEWERDRAWGETPAUSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerdrawgetpause_ petscviewerdrawgetpause
#endif
PETSC_EXTERN void petscviewerdrawgetpause_(PetscViewer *a, PetscReal *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLREAL(b);
  *ierr = PetscViewerDrawGetPause(v_a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerdrawsetpause_ PETSCVIEWERDRAWSETPAUSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerdrawsetpause_ petscviewerdrawsetpause
#endif
PETSC_EXTERN void petscviewerdrawsetpause_(PetscViewer *a, PetscReal *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerDrawSetPause(v_a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerdrawsethold_ PETSCVIEWERDRAWSETHOLD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerdrawsethold_ petscviewerdrawsethold
#endif
PETSC_EXTERN void petscviewerdrawsethold_(PetscViewer *a, PetscBool *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerDrawSetHold(v_a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerdrawgethold_ PETSCVIEWERDRAWGETHOLD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerdrawgethold_ petscviewerdrawgethold
#endif
PETSC_EXTERN void petscviewerdrawgethold_(PetscViewer *a, PetscBool *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscViewerDrawGetHold(v_a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerdrawsetbounds_ PETSCVIEWERDRAWSETBOUNDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerdrawsetbounds_ petscviewerdrawsetbounds
#endif
PETSC_EXTERN void petscviewerdrawsetbounds_(PetscViewer *a, PetscInt *b, const PetscReal *c, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLREAL(c);
  *ierr = PetscViewerDrawSetBounds(v_a, *b, c);
  if (*ierr) return;
}
